
function [lset,dt_first] = move_NB(Cvel_NB,lset,xco,yco,status_set,alpha,calcdt,Cvel_edge)

first_term = Cvel_NB;
kappa_term = zeros(size(lset));
nbsz = length(xco);

if exist('Cvel_edge')
    second_term = Cvel_edge;
else
    second_term = zeros(size(lset));
end

% max_term = max(abs(first_term(:)));
% k_term = alpha*max(abs(kappa_term(:)));
% c = max(max_term,k_term); % chk?
%
% if(c ~= 0)
%    dt = 0.5/c;
% else
%    dt = inf;
%    fprintf('dt is infinite, c == 0\n');
%    lset = re_distance(lset,35);
% end
%
for k = 1:nbsz   % calculating curvature and grad_phi at each point in the NB
    lyf.vals = lset(xco(k),yco(k)+1);
    lyb.vals = lset(xco(k),yco(k)-1);
    lxf.vals = lset(xco(k)+1,yco(k));
    lxb.vals = lset(xco(k)-1,yco(k));
    lbb.vals = lset(xco(k)-1,yco(k)-1);
    lff.vals = lset(xco(k)+1,yco(k)+1);
    lyfxb.vals = lset(xco(k)-1,yco(k)+1);
    lybxf.vals = lset(xco(k)+1,yco(k)-1);
    lv = lset(xco(k),yco(k));
    ly = (lyf.vals-lyb.vals)/2;
    lx = (lxf.vals-lxb.vals)/2;
    lxy = 0.25 * (lff.vals - lybxf.vals - lyfxb.vals + lbb.vals);
    lxx = lxf.vals - 2 * lv + lxb.vals;
    lyy = lyf.vals - 2 * lv + lyb.vals;
    lx2 = lx^2;
    ly2 = ly^2;
    kap = (ly2 * lxx - 2 * lx * ly * lxy + lx2 * lyy);
    kappa = kap./(0.01+lx2+ly2);
    kappa_term(xco(k),yco(k)) = kappa;

    % Calculating grad minus and grad plus at each point in NB
    Dx_m = lv - lxb.vals;
    Dx_p = lxf.vals - lv;
    Dy_m = lv - lyb.vals;
    Dy_p = lyf.vals - lv;
    grad_p = sqrt(max(Dx_m,0)^2 + min(Dx_p,0)^2 + max(Dy_m,0)^2 + min(Dy_p,0)^2);
    grad_m = sqrt(min(Dx_m,0)^2 + max(Dx_p,0)^2 + min(Dy_m,0)^2 + max(Dy_p,0)^2);

    if (first_term(xco(k),yco(k)) > 0)
        first_term(xco(k),yco(k)) = first_term(xco(k),yco(k)) * grad_m;
    else
        first_term(xco(k),yco(k)) = first_term(xco(k),yco(k)) * grad_p;
    end
    if (second_term(xco(k),yco(k)) > 0)
        second_term(xco(k),yco(k)) = second_term(xco(k),yco(k)) * grad_m;
    else
        second_term(xco(k),yco(k)) = second_term(xco(k),yco(k)) * grad_p;
    end
    
end %for k

if (calcdt)
    dt_first = min(2-alpha, (2-alpha)/max(abs(first_term(:))) );
else
    dt_first = 1;
end

kmx = max(abs(kappa_term(:)));
if kmx==0
    dt_kappa = 0;  disp('kappa term is zero'), keyboard
else
    dt_kappa = min(alpha, alpha/kmx);
end
% NOTE: +kappa_term: smoothes the contour, +: move inside

if exist('Cvel_edge')
    dt_second = min(alpha, alpha/max(abs(second_term(:))) );
    lset = lset + dt_first * first_term + dt_second * second_term;
else
    lset = lset +  dt_first * first_term + dt_kappa * kappa_term;
end

%[grad_lsetx,grad_lsety] = gradient(lset);
% grad_lset_mag = sqrt(grad_lsetx.^2 + grad_lsety.^2);
%lset = lset + first_term - g.*kappa_term + gradgx.*normal


