% weighting and resampling step of PF

% if remove "state=stateIS, levset = levsetIS" then will be using stateIS only for display, all PF will be done without IS
function [prodweight, prodweightold, levset_resamp, state_resamp,pyt] = evidencesample( levset,state,Y,t,prodweight, prodweightold, levsetIS,stateIS,u,v );
global n py_thresh M objectclass
global K
global alpha
global Sigma0 A Signoise
global u0 v0 u2 sig2obs eps gamma sig2curve
global sz energyscale
global zerolength changetopo atbndry setzero
global usingeigvecs eigvecs
global Kt impsampling impsampiters  resampinterval
global dmax rho alpha sig2obsedge subsamplerate edgemin edgemax
global objecttype 

% when n is so small, need a large difference in weights to ensure utility of random sampling. else better to deterministically resample

[bw,thresh]=edge(Y,'canny',[edgemin*sqrt(sig2obs)/255  edgemax*sqrt(sig2obs)/255]); % getting edge map
totedge = sum(sum(bw));

levset0=levset; state0=state;
levset = levsetIS; state = stateIS;

for m =1:M   % for more than one object
    logw = zeros(n,1);
    object1 = objectclass(m)==1;  
    for i = 1:n
        % read in the contour and lset
        C = state(i,m).C;
        [lset0,xco0,yco0,status_set0] = getlevset(levset0(i,m));
        [lset,xco,yco,status_set] = getlevset(levset(i,m));

        % computing edge weight, obs contour
        [edgedist] = findedge(C(:,1:subsamplerate:end),bw);    % incorporate findedge into extend2 (when iter==totiter) - save time    % use distance square
        minedgedist = (edgedist > dmax).*rho + (edgedist <=dmax).*edgedist;
        lenC = length(minedgedist);
        edgewt(i)   = -sum(minedgedist.^2)/(2*sig2obsedge*lenC);

        % computing  log[ p(C_t^{i}|\hat{C}_t^{i}) ]
        [normalizeddist2,curvedist2] = set_symmetric_dist(lset,lset0);
        curvewt(i) = - curvedist2/(2*length(C)*sig2curve);
        %clutterwt(i) =  - log(alpha) * (totedge-length(C))/totedge ;  % wrong because not using every C value clutterwt(i) =   (totedge-lenC)*log(alpha) ;

        % computing region weight        
        inside = lset <= 0;
        outside = lset > 0; %To Do: take region close to zero lsets of all particles
        if (objecttype==1)  %model for tracking object 1: background has 2 classes
            regionu2 = outside.*( abs(Y-u2) <= abs(Y-v0) );
            regionv0 = outside.*( abs(Y-u2) > abs(Y-v0) );
            regionu0 = inside;
        else         %tracking object 2
            regionu0 = inside.*( abs(Y-u0) <= abs(Y-u2) );
            regionu2 = inside.*( abs(Y-u0) >  abs(Y-u2) );
            regionv0 = outside;
            %   regionwt(i) = -mean2( ((Y-u2).*regionu2).^2 + ((Y-u0).*regionu0).^2 + ((Y-v0).*regionv0).^2 )/(2*sig2obs);
        end
        regionwt(i) = -mean2( ((Y-u0).*regionu0).^2 + ((Y-u2).*regionu2).^2 + ((Y-v0).*regionv0).^2 )/(2*sig2obs);

        % adding all 3 log of weights
        logw(i) = ( edgewt(i) + curvewt(i)+ regionwt(i) ); %; % + clutterwt(i);
    end  %for i = 1:n
    
    % computing the unnormalized weights
    weightunnorm = exp( logw - min(logw) - setzero(:,m)*1e70) ;  %minimum value will be 1

    % computing normalized weights: requires weightunnorm as input
    if (t==1)
        prodweight(1:n,m,t) = weightunnorm/sum(weightunnorm);
    else
        prodweight(1:n,m,t) = prodweight(1:n,m,t-1).*weightunnorm;
    end
    prodweightold(1:n,m,t) = prodweight(1:n,m,t);

    if  mean2(isnan(prodweight(:,:,t)))>0
        keyboard
    end

    %resampling: requires prodweight as input and need to know resampinterval
    if (mod(t,resampinterval)==0)  | (t<=2)  %| (sum(setzero)>0)
        weight = prodweight(1:n,m,t) / sum( prodweight(1:n,m,t) );
        indx = discretesample(weight,[1:n],n);
        prodweight(1:n,m,t) = 1/n;
         %[indx,residualwt,parent,indxct] = stratifiedsample(weight,[1:n]',n);
         %prodweight(1:n,m,t) = residualwt ;
    else
        indx = [1:n];
    end
    levset_resamp(1:n,m) = levset(indx,m);
    state_resamp(1:n,m) = state(indx,m);
    
    %computing p(Y_t|Y_{1:t-1},m) for the m^{th} object
     pyx = weightunnorm * exp(min(logw)); %p(Y_t|X_t)
     if (t>1)
         tmp = prodweight(:,m,t-1);
         pxyold = tmp/sum(tmp);
     else
         pxyold = 1/n;
     end
     pyt(m,t) = sum(pyx.*pxyold);

end %for m=1:M

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%     if (mean2(regionu2)>0)
%         Ybaru2 = mean2(Y.*regionu2)/mean2(regionu2); %If inside pixels on outside,they will be closer to u2
%     else
%         Ybaru2 = u2; %so that Ybaru2-u2=0
%     end
%     if (mean2(regionv0)>0)
%         Ybarv0 = mean2(Y.*regionv0)/mean2(regionv0);
%     else
%         Ybarv0 = v0; %so that Ybarv0-v0=0
%     end
%     Ybarinside = mean2(Y.*inside)/mean2(inside);
%     regionwt0(i) = -( (Ybarinside-u0)^2 + (Ybaru2 - u2)^2 + (Ybarv0 - v0)^2 )/ (2*sig2obs);

%regionwt(i) =- mean2( ( ((Y-u0).*inside ).^2 )/(2*sig2obs) );


% prob = sum(wt_unnorm)
% if (prob > py_thresh)
%     weight = wt_unnorm/prob;
% else
%     wt_unnorm = wt_unnorm+py_thresh;
%     prob = sum(wt_unnorm);
%     weight = wt_unnorm/prob;
% end
% for i = 1:n
%     difenergy = energy - energy(i);
%     weight(i,1) = 1/( sum( exp(-difenergy) ) );
% end
