%gendata_2obj_geom
% works for learning parameters for simulated sequence (generated using gendata_2obj_geom)
% get values close to what we used for the simulation.

clear Ctranshat

if (~exist('state'))  %if a real sequence, then need to read in training data
    strt = 347;   % trying to get it to work for car sequence, unsuccessful
    for t = 1:T % reading in training data
        imno = strt +t;
        fname = sprintf('../moving_car/red_car_%d.png',imno);
        frame0 = imread(fname);
        cont = (imresize(frame0,0.5,'bilinear'));
        [x_co,y_co] = trace_curve(cont);
        C0 = [x_co(2:end);y_co(2:end)];
        [lset,xco,yco,status_set] = define_lset(C0,cont)
        getcontour;
        imshow(cont); hold on, plotcontour(C0,'r'); plotcontour(C,'b');pause
        state3(t)=struct('C',C)
    end
    state = state3;
end

[C] = getstate(state(1)); %or read in contour somehow
Cvel_basishat = zeros(K,T);
Ctranshat = zeros(tdim,T);
for t = 2:T
    [Cnew] = getstate(state(t)); %or read in contour somehow
    len = length(C);
    Cnewhat = zeros(size(C));
    for ct = 1:len
        point = C(:,ct);
        [indx,Cnewhat(:,ct),mindist] = getclosest(point,Cnew);
    end

    figure(1),imshow(Yt{t}/255); plotcontour(C,'b'); hold on, plotcontour(Cnew,'r'); plotcontour(Cnewhat,'k');
    drawnow, hold on,
    centroid_C = mean(C,2);
    Cc = C - centroid_C*ones(1,len);
    centroid_Cnewhat = mean(Cnewhat,2);
    Cnewhatc = Cnewhat - centroid_Cnewhat*ones(1,len);

    centroid_Cnew = mean(Cnew,2);
    Ctranshat(:,t) = centroid_Cnew - centroid_C;
    Cvelhat = Cnewhatc - Cc;
    [N,TT,sgn]=get_normal(C);
    [N2,TT,sgn2]=get_normal(Cnewhat);
    if (sgn*sgn2==-1)
        disp('C,Cnewhat clockwise or anticlockwise'), keyboard
    end
    if  (sgn==-1)      %(sgn==1)&(t>2): screwing up'
        %        Cc = Cc(:,end:-1:1);
        %      C = C(:,end:-1:1);
        %        Cvelhat = Cvelhat(:,end:-1:1);
        %       [N,TT,sgn] = get_normal(C,lset);   % disp(sprintf('sign %d',sgn))
        N = -N;
    end

    CvelhatN = sum(N.*Cvelhat,1);  %taking dot product with the normal of C
    figure(2), plot(sqrt(sum(Cvelhat.^2,1))), hold on, plot(abs(CvelhatN),'r'), hold off
    thetaknots = [0:2*pi/K:2*pi*(K-1)/K] ;
    ang = atan2(Cc(2,:),Cc(1,:)) ;
    thetaCc = ang + (ang<0)*2*pi;
    [B] = get_basis_fns_theta(thetaCc,thetaknots,K);
    Cvel_basis_fullhat = pinv(B'* B) * B'*CvelhatN';
	disp('why pinv')
	disp('arrange Cvelhat and B in increasing order of theta')
    Cvel_basishat(1:K,t) = Cvel_basis_fullhat(1:K); % or Cvel_basis_fullhat(order: K+order)??
    C = Cnew ;%hat; %not Cnew because Cnewhat in the same order as old C
    %pause
end

% computing signoise
disp('can learn a as well or learn ai for the ith knot')
nois = Cvel_basishat(:,3:end) - a*Cvel_basishat(:,2:end-1);
signoisehat = mean(nois.^2,2)'

nois_trans = Ctranshat(:,3:end) - atrans*Ctranshat(:,2:end-1);
signoise_transhat = mean(nois_trans.^2,2)'

for t=2:T
    Cvel_basis(1:K,t) = state(t).Cvel_basis;
    Ctrans(:,t) = state(t).Ctrans;
end
nois_state = Cvel_basis(:,3:end) - a*Cvel_basis(:,2:end-1);
signoisehat_state = mean(nois_state.^2,2)'
nois_trans_state = Ctrans(:,3:end) - atrans*Ctrans(:,2:end-1);
signoise_transhat_state = mean(nois_trans_state.^2,2)'


