%parametric basis: learning the system model for translation + deformation
%INPUT: the clean contours, dopt, dmin2, dmax2

%OUTPUT:
%translate: atrans, signoise_trans, sigma0_trans
% deform: K, Ktsim
% a, signoise(1:K), sigma0(1:K)

disp('key question: how do you fix the physical location of knotloc(:,1) or knotindx(1)')
disp('translation learning missing')
[C] = getstate(state(1)); %or read in contour somehow
Cvel_basishat = zeros(K,T);
[knotloc,knotindx] = get_uniform_knots(C,K);
for t = 2:T
    [Cnew] = getstate(state(t)); %or read in contour somehow
    Cnewhat = zeros(size(C));
    for ct = 1:length(C)
        point = C(:,ct);
        [indx,Cnewhat(:,ct),mindist] = getclosest(point,Cnew);
    end
    Cvelhat = Cnewhat - C;
    [arclen,dCdp] = get_arclength(C);
    [B,n0,k0,n,strt] = get_basis_functions(arclen,knotindx,K);

    Cvel_basis_fullhat = inv(B'* B) * B'*Cvelhat';
    Cvel_basishat(1:K,t) = Cvel_basis_fullhat(1:K);
    % Test for correctness
    %Cvel_basis_full(1:K,1) = Cvel_basis(:,t); Cvel_basis_full(K+1:K+order-1,1) = Cvel_basis(1:order-1,t);
    %Cvel_hat = B*Cvel_basis_full
    knotloc_moved = knotloc + Cvelhat(knotindx);
    C = Cnew;
    [knotloc, knotindx] = find_knot_indices(C,knotloc_moved);

    % detectknotschange: outputs Knew also
    % if knotschange, K=Knew; Ktsim(t)=K; [knotloc,knotindx] = get_uniform_knots(C,K); end

end

%learn system dynamics for chunks of equal K
t=1;
K=Ktsim(t);





   
    

