function [edge_term] = get_velocity_edge(img,lset,xco,yco)

h = fspecial('gaussian');
gimg = imfilter(img,h);
[Ix,Iy] = gradient(gimg);
gradmag2 = sqrt(Ix.^2 + Iy.^2);
c=10;
g = 1./(1+c*gradmag2);
[grad_gx,grad_gy] = gradient(g);

kappa_term = zeros(size(lset));
nbsz = length(xco);
for k = 1:nbsz     % calculating curvature at each point in the NB
    lyf.vals = lset(xco(k),yco(k)+1);
    lyb.vals = lset(xco(k),yco(k)-1);
    lxf.vals = lset(xco(k)+1,yco(k));
    lxb.vals = lset(xco(k)-1,yco(k));
    lbb.vals = lset(xco(k)-1,yco(k)-1);
    lff.vals = lset(xco(k)+1,yco(k)+1);
    lyfxb.vals = lset(xco(k)-1,yco(k)+1);
    lybxf.vals = lset(xco(k)+1,yco(k)-1);
    lv = lset(xco(k),yco(k));
    ly = (lyf.vals-lyb.vals)/2;
    lx = (lxf.vals-lxb.vals)/2;
    lxy = 0.25 * (lff.vals - lybxf.vals - lyfxb.vals + lbb.vals);
    lxx = lxf.vals - 2 * lv + lxb.vals;
    lyy = lyf.vals - 2 * lv + lyb.vals;
    lx2 = lx^2;
    ly2 = ly^2;
    kap = (ly2 * lxx - 2 * lx * ly * lxy + lx2 * lyy);
    kappa = kap./(0.01+lx2+ly2);
    kappa_term(xco(k),yco(k)) = kappa;
end
edge_term1 =  g.* (kappa_term + 0.5 ); %alpha*

[grad_lsetx,grad_lsety] = gradient(lset); %(Dx_p+Dx_m)/2;grad_lsety = (Dy_p+Dy_m)/2; 
norm_grad_lset = sqrt(grad_lsetx.^2 + grad_lsety.^2)+0.0001;
edge_term2 = (grad_gx.*grad_lsetx + grad_gy.*grad_lsety)./norm_grad_lset;

edge_term = edge_term1+ edge_term2;


