function [first_term,u,v] = get_velocity_chanvese(img,lset,xco,yco)
global u0 v0 u2 objecttype
[nx,ny] = size(lset);
nbsz = length(xco);

%finding u and v in a window around the zero level set
xc = round(mean(xco));
yc = round(mean(yco));
xmin = min(xco);
xmax = max(xco);
ymin = min(yco);
ymax = max(yco);
xoff = (xmax-xmin)+2;
yoff = (ymax-ymin)+2;
yc_m_off = yc-yoff;
yc_p_off = yc+yoff;
xc_m_off = xc-xoff;
xc_p_off = xc+xoff;

if(yc-yoff<=0)
    yc_m_off=1;
end
if(yc+yoff>ny)
    yc_p_off=ny;
end
if(xc-xoff<=0)
    xc_m_off=1;
end
if(xc+xoff>nx)
    xc_p_off=nx;
end
wind_phi = img(xc_m_off:xc_p_off,yc_m_off:yc_p_off);
wind_lset = lset(xc_m_off:xc_p_off,yc_m_off:yc_p_off);
[mx,my] = size(wind_lset);
zset = find(wind_lset>0);
v = mean(wind_phi(zset));
%Av = size(zeroset,1);
nt = find(wind_lset<0);
[Au,dumy] = size(nt);
u = sum(wind_phi(nt))/Au;

%u = u0;

% second_term = -((0.5*u+0.5*v) - img);

% simulating the "delta function" described in Chan-Vese paper - NOT
% NEEDED because  want to extend the velocity - may introduce numerical
% instability if lset tooo small
%first_term= (1./(1+lset.^2)).*((img-u).^2 - (img-v).^2) + 1 * second_term;

first_term= ((img-u).^2 - (img-v).^2) ;%+ 1 * second_term;

if (objecttype==1)
    va = v0; vb = u2;
    regionva=( abs(img-va) <= abs(img-vb) ); regionvb=(abs(img-va) > abs(img-vb) );
    first_term = (img-u0).^2 - ( regionva.*(img-va).^2  + regionvb.*(img-vb).^2 );
end

if (objecttype==2)
    ua = u0; ub = u2;
    regionua=( abs(img-ua) <= abs(img-ub) ); regionub=(abs(img-ua) > abs(img-ub) );
    first_term = (img-v0).^2 - ( regionua.*(img-ua).^2  + regionub.*(img-ub).^2 );
end
% set objecttype=3 if want to learn the mean intensity. 
