%[Cdot,knotloc,knotindx,N,Cdot_basis,strt] =get_velocity(C,K,need_uniform,oldknotloc,Cdot_basis,lset)
% finds the closest knot location on current contour,
% re-arranges contour C so that strt=knotindx(1)=1, then knotindx's always sorted  
%Evaluates normal N
%arclength parametrization to get basis functions and evaluates Cdot using the basis functions

function [C,Cdot,knotloc,knotindx,N,Cdot_basis,strt]  = get_velocity(C,K,need_uniform,oldknotloc,Cdot_basis,lset)
tot = length(C);

if (need_uniform)
    [knotloc,knotindx,knotdist] = get_uniform_knots(C,K);
else
    [knotloc, knotindx, knotdist] = find_knot_indices(C,oldknotloc);
end

strt=knotindx(1);
if (strt~=1) % re-arranges contour C so that strt=1
    Cnew = C(:,[strt:end,1:strt-1]);  %re-arrange C so that strt=1
    %   NOT A PROBLEM: 'only taking care of case where knotindx(1) is unsorted, knotindx(end) could also be a problem'
    knotindx_tmp=knotindx; C_tmp = C;
    C = Cnew;    strt=1;
    [knotloc, knotindx, knotdist] = find_knot_indices(C,oldknotloc);
end
if (~isequal(sort(knotindx),knotindx) ) | (knotindx(1)~=1)
    disp('either knotindx(1)~=1 or knotindx not sorted, should not happen'),  keyboard
    %happening when there is changetopo - okay work on it later
end

%[N,T,sgn] = get_normal(C,lset);
[N,T,sgn] = get_normal(C);

[arclen,dCdp] = get_arclength(C);
[Cdot] = get_interp(Cdot_basis,arclen,knotindx,K); %gets the basis functions for current arclength param of contour and interpolates Cdot_basis


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%OLD JUNK
%sorts knotindx (and also knotloc, Cdot_basis), and interpolates Cdot_basis using current contour's
% if ~isequal(sort(knotindx),knotindx)
%     'knotindx should not be unsorted'
%    % sort knotindx knotloc and Cdot_basis
%    % required coz sometimes knotloc(:,1) is close to the last point of contour
%     knotindx0=knotindx; knotloc0=knotloc; Cdot_basis0=Cdot_basis;
%     [ki,indx] = sort(knotindx);
%     knotindx = knotindx(indx);
%     Cdot_basis = Cdot_basis(indx);
%     knotloc = knotloc(:,indx);
% end
%%%Cdot_basis = randn(K,1); %[1:K]' %
% Cdot has been re-arranged to start at indx=1 (not at indx=strt)
% Instead now we want to re-arrange C so that strt=1 - then no need to re-arrange Cdot
% Do "extend2" correctly and to do Cvel.*N correctly: this is being DONE since Cdot starts at the same place (strt) as C


% [dC,tmp]=gradient(C);
% dC(:,1) = (C(:,2)-C(:,end))/2;
% dC(:,end) = (C(:,1)-C(:,end-1))/2;
% dCdp=dC;
% normdCdp = sum(dCdp.^2,1).^(1/2);
% T = dCdp./(ones(2,1)*normdCdp);
% N = - [-T(2,:); T(1,:)];

%plotnormal, figure(1),

% figure(7)
% C2 = C + N.* (ones(2,1)*Cdot);
% plot(C(1,:),C(2,:),'-o')
% hold on
% plot(C2(1,:),C2(2,:),'r-*')
% Cfin=C+ 2*N;
% Cfin_in = C-2*N;
% for k = 1: tot
%    plot([Cfin_in(1,k),Cfin(1,k)],[Cfin_in(2,k),Cfin(2,k)],'g--')
% end
% hold off








