%[basis_functions,n0,k0,n,strt] = get_basis_functions(arclen,knotindx,K)
% obtaining Bspline basis functions at current arclen param
% every basis fn starts at indx=strt, i.e. p(1) = arclen(knotindx(1))/len (very close to 0)
function  [basis_functions,n0,k0,n,strt] = get_basis_functions(arclen,knotindx,K)
global order
len = arclen(end);
%K = length(Cdot_basis);
n0=K; k0=order;
n = n0+k0-1;

% pknots(k0:n+1) = [arclen(knotindx)/len , 1];
% pknots(1:k0-1) = -arclen(knotindx(k0:-1:2))/len;
% pknots(n+2:n+k0) = 1 + arclen(knotindx(2:k0))/len; 

pknots(k0:n) = arclen(knotindx)/len;
% setting p for knot indices n+1:n+k0, 1:k0-1
dif = arclen(knotindx(1:k0)) - arclen(knotindx(end)) ;
pknots(n+1:n+k0) = pknots(n) + ( dif + len*(dif<0) )/len;
dif2 = arclen(knotindx(end-k0+2:end)) - arclen(knotindx(1));
pknots(1:k0-1) = pknots(k0) + ( dif2 - len*(dif2>0) )/len;

% When strt=knotindx(1)==1, then p=p0= arclen(strt:end)/len;

% the following ensures (p>=pknots(k0)) & (p<=pknots(n+1)): rearranging p
% to start from knotindx(1)
strt=knotindx(1);
p0 = arclen(strt:end)/len;
prt = ( len + arclen(1:strt-1) )/len;
p = [p0,prt];

basis_functions = coxdeboor3(k0,n,pknots',p',k0);



% picorrect_index = find( (pknots>=pknots(k0)) & (pknots<=pknots(n+1)) );
% picorrect = pknots(picorrect_index);
% 
% pcorrect_index = find( (p>=pknots(k0)) & (p<=pknots(n+1)) );
% pcorrect = p(pcorrect_index);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
