function [extend_this,sdist] = extend_initialize(lset,xco,yco,term)

%this funciton initializes phi_hat so that we can do 
%Fast marching to extend the array
% we also return a temporary signed distance function
% here we use the Affine invariant model to extend phi,phi_x,phi_y
%using the following formula:
 %phi_hat= phi + 0.5 (phi_x * x + phi_y * y)
 
% signs in the signed distacne function is negative inside and
% psitive outside. if you need only positive values, find all hte
% negative ones and set them to zero.
%Assume lset,phi,phi_x,phi_y are all extended arrays by 1 in each
%direction

[nx,ny] = size(lset);
extend_this = zeros(nx,ny);
sdist = zeros(nx,ny);

nbsz = length(xco);

%[first_term,u,v] = get_velocity_chanvese(img,lset,xco,yco);

phi = term;
phi_x = zeros(size(phi));
phi_y = zeros(size(phi));

   %for x = 2:nx-2
    %     for  y = 2:ny-2
     for pt = 1:nbsz
          x = xco(pt);
          y = yco(pt);
             if((lset(x+1,y)>0)&(lset(x+1,y+1)<=0))
                  
                  %calculate speed at the zero level set
                  %our interface is between y & y+1
                  dl = abs(lset(x+1,y));
                  dr = abs(lset(x+1,y+1));
                  offset = dl/(dl+dr);
                  yc = y + offset;
                  t = offset;
                  
                  ph = (y-yc) * (phi(x+1,y)-phi(x+1,y+1)) + phi(x+1,y);
                  px = (y-yc) * (phi_x(x+1,y)-phi_x(x+1,y+1)) + phi_x(x+1,y);
                  py = (y-yc) * (phi_y(x+1,y)-phi_y(x+1,y+1)) + phi_y(x+1,y);
                  
                  et_a = ph + 0.5 * (x * px +  py * yc);
                  extend_this(x,y-1) = et_a;
                  sdist(x,y-1) = t;
                  sdist(x,y) = -dr/(dl+dr); %inside the interface, dist is negative
                  extend_this(x,y) = et_a;
                  
                  %if our interface is between (x+1 & x+2) & (y & y+1) & 
                  %(x & x+1)
                  if((lset(x+1,y)>0) & (lset(x+2,y) <= 0) & (lset(x,y) <=0))
                      dl = abs(lset(x+1,y));
                      dr = abs(lset(x+2,y));
                      dtop = abs(lset(x,y));
                        
                      if(dr>=dtop) %use distance, dtop
                          dr = dtop;
                          s = dl/(dl+dr);
                          xc = x - s;
                          
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x,y-1) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (x-xc) * (phi(x,y)-phi(x+1,y)) + phi(x,y);
                          px = (x-xc) * (phi_x(x,y)-phi_x(x+1,y)) + phi_x(x,y);
                          py = (x-xc) * (phi_y(x,y)-phi_y(x+1,y)) + phi_y(x,y); 
                          et_b = ph + 0.5 * (xc * px +  py * y);
                          extend_this(x,y-1) = (t2 * et_a + s2 * et_b)/(t2+s2);
                          
                      else  %distance dr is smaller, so use it
                               
                          s = dl/(dl+dr);
                          xc = x + s;
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x,y-1) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (x-xc) * (phi(x+1,y)-phi(x+2,y)) + phi(x+1,y);
                          px = (x-xc) * (phi_x(x+1,y)-phi_x(x+2,y)) + phi_x(x+1,y);
                          py = (x-xc) * (phi_y(x+1,y)-phi_y(x+2,y)) + phi_y(x+1,y); 
                          et_b = ph + 0.5 * (xc * px +  py * y);
                          extend_this(x,y-1) = (t2 * et_a + s2 * et_b)/(t2+s2);
                      end
                         
                  end
                  
                  %if our interface is between (x+1 & x+2) & (y & y+1) only
                      if((lset(x+1,y)>0)&(lset(x+2,y)<=0)&(lset(x,y)>0))
                          dl = abs(lset(x+1,y));
                          dr = abs(lset(x+2,y));
                          s = dl/(dl+dr);
                          xc = x + s;
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x,y-1) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (x-xc) * (phi(x+1,y)-phi(x+2,y)) + phi(x+1,y);
                          px = (x-xc) * (phi_x(x+1,y)-phi_x(x+2,y)) + phi_x(x+1,y);
                          py = (x-xc) * (phi_y(x+1,y)-phi_y(x+2,y)) + phi_y(x+1,y); 
                          et_b = ph + 0.5 * (xc * px +  py * y);
                          extend_this(x,y-1) = (t2 * et_a + s2 * et_b)/(t2+s2);  
                          
                      end
              
              end %y>0,y+1<0      
              
              %next case, y<0 & y+1>0
              
              if((lset(x+1,y)<0)&(lset(x+1,y+1)>=0))
                  
                  %calculate speed at the zero level set
                  %our interface is between y & y+1
                  dl = abs(lset(x+1,y));
                  dr = abs(lset(x+1,y+1));
                  offset = dl/(dl+dr);
                  yc = y + offset;
                  t = offset;
                  
                  ph = (y-yc) * (phi(x+1,y)-phi(x+1,y+1)) + phi(x+1,y);
                  px = (y-yc) * (phi_x(x+1,y)-phi_x(x+1,y+1)) + phi_x(x+1,y);
                  py = (y-yc) * (phi_y(x+1,y)-phi_y(x+1,y+1)) + phi_y(x+1,y);
                  
                  et_a = ph + 0.5 * (x * px +  py * yc);
                  extend_this(x,y-1) = et_a;
                  sdist(x,y-1) = -t;
                  sdist(x,y) = dr/(dl+dr);
                  extend_this(x,y) = et_a;
                  %if our interface is between (x+1 & x+2) & (y & y+1) & 
                  %(x & x+1)
                  if((lset(x+1,y)<0) & (lset(x+2,y) >= 0) & (lset(x,y) >=0))
                      dl = abs(lset(x+1,y));
                      dr = abs(lset(x+2,y));
                      dtop = abs(lset(x,y));
                        
                      if(dr>=dtop) %use distance, dtop
                          dr = dtop;
                          s = dl/(dl+dr);
                          xc = x - s;
                          
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x,y-1) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (x-xc) * (phi(x,y)-phi(x+1,y)) + phi(x,y);
                          px = (x-xc) * (phi_x(x,y)-phi_x(x+1,y)) + phi_x(x,y);
                          py = (x-xc) * (phi_y(x,y)-phi_y(x+1,y)) + phi_y(x,y); 
                          et_b = ph + 0.5 * (xc * px +  py * y);
                          extend_this(x,y-1) = (t2 * et_a + s2 * et_b)/(t2+s2);
                          
                      else  %distance dr is smaller, so use it
                               
                          s = dl/(dl+dr);
                          xc = x + s;
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x,y-1) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (x-xc) * (phi(x+1,y)-phi(x+2,y)) + phi(x+1,y);
                          px = (x-xc) * (phi_x(x+1,y)-phi_x(x+2,y)) + phi_x(x+1,y);
                          py = (x-xc) * (phi_y(x+1,y)-phi_y(x+2,y)) + phi_y(x+1,y); 
                          et_b = ph + 0.5 * (xc * px +  py * y);
                          extend_this(x,y-1) = (t2 * et_a + s2 * et_b)/(t2+s2);
                      end
                         
                  end
                  
                  %if our interface is between (x+1 & x+2) & (y & y+1) only
                      if((lset(x+1,y)<0)&(lset(x+2,y)>=0)&(lset(x,y)<0))
                          dl = abs(lset(x+1,y));
                          dr = abs(lset(x+2,y));
                          s = dl/(dl+dr);
                          xc = x + s;
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x,y-1) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (x-xc) * (phi(x+1,y)-phi(x+2,y)) + phi(x+1,y);
                          px = (x-xc) * (phi_x(x+1,y)-phi_x(x+2,y)) + phi_x(x+1,y);
                          py = (x-xc) * (phi_y(x+1,y)-phi_y(x+2,y)) + phi_y(x+1,y); 
                          et_b = ph + 0.5 * (xc * px +  py * y);
                          extend_this(x,y-1) = (t2 * et_a + s2 * et_b)/(t2+s2);  
                          
                      end
                  
              end %y<0,y+1>0  
              
              %case in x direction
              %in this case, we dont consider interface which is covered in
              %one of the above if statements,hence lset(x+1,y+2)<=0
              if((lset(x,y+1)>0)&(lset(x+1,y+1)<=0)&(lset(x+1,y+2)<=0))
                  %calculate speed at the zero level set
                  %our interface is between y & y+1
                  dl = abs(lset(x,y+1));
                  dr = abs(lset(x+1,y+1));
                  offset = dl/(dl+dr);
                  xc = x + offset;
                  t = offset;
                  
                  ph = (x-xc) * (phi(x,y+1)-phi(x+1,y+1)) + phi(x,y+1);
                  px = (x-xc) * (phi_x(x,y+1)-phi_x(x+1,y+1)) + phi_x(x,y+1);
                  py = (x-xc) * (phi_y(x,y+1)-phi_y(x+1,y+1)) + phi_y(x,y+1);
                  
                  et_a = ph + 0.5 * (xc * px +  py * y);
                  extend_this(x-1,y) = et_a;
                  sdist(x-1,y) = t;
                  sdist(x,y) = -dr/(dl+dr); %dist inside the interface
                  extend_this(x,y) = et_a;
                  %if our interface is between (y+1 & y+2) & (x & x+1) & 
                  %(y & y+1)
                  if((lset(x,y+1)>0) & (lset(x,y+2) <= 0) & (lset(x,y) <=0))
                      dl = abs(lset(x,y+1));
                      dr = abs(lset(x,y+2));
                      dleft = abs(lset(x,y));
                        
                      if(dr>=dleft) %use distance, dtop
                          dr = dleft;
                          s = dl/(dl+dr);
                          yc = y - s;
                          
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x-1,y) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (y-yc) * (phi(x,y)-phi(x,y+1)) + phi(x,y);
                          px = (y-yc) * (phi_x(x,y)-phi_x(x,y+1)) + phi_x(x,y);
                          py = (y-yc) * (phi_y(x,y)-phi_y(x,y+1)) + phi_y(x,y); 
                          et_b = ph + 0.5 * (x * px +  py * yc);
                          extend_this(x-1,y) = (t2 * et_a + s2 * et_b)/(t2+s2);
                          
                      else  %distance dr is smaller, so use it
                               
                          s = dl/(dl+dr);
                          yc = y + s;
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x-1,y) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (y-yc) * (phi(x,y+1)-phi(x,y+2)) + phi(x,y+1);
                          px = (y-yc) * (phi_x(x,y+1)-phi_x(x,y+2)) + phi_x(x,y+1);
                          py = (y-yc) * (phi_y(x,y+1)-phi_y(x,y+2)) + phi_y(x,y+1); 
                          et_b = ph + 0.5 * (x * px +  py * yc);
                          extend_this(x-1,y) = (t2 * et_a + s2 * et_b)/(t2+s2);
                      end
                         
                  end
                  
                  %if our interface is between (x & x+1) & (y & y+1) only
                      if((lset(x,y+1)>0)&(lset(x,y+2)<=0)&(lset(x,y)>0))
                          dl = abs(lset(x,y+1));
                          dr = abs(lset(x,y+2));
                          s = dl/(dl+dr);
                          yc = y + s;
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x-1,y) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (y-yc) * (phi(x,y+1)-phi(x,y+2)) + phi(x,y+1);
                          px = (y-yc) * (phi_x(x,y+1)-phi_x(x,y+2)) + phi_x(x,y+1);
                          py = (y-yc) * (phi_y(x,y+1)-phi_y(x,y+2)) + phi_y(x,y+1); 
                          et_b = ph + 0.5 * (x * px +  py * yc);
                          extend_this(x-1,y) = (t2 * et_a + s2 * et_b)/(t2+s2);
                          
                      end
                  
              end %x>0,x+1<0      
              
              %another case in x -direction, but with reversed signs
              if((lset(x,y+1)<0)&(lset(x+1,y+1)>=0)&(lset(x+1,y+2)>=0))
                  
                  %calculate speed at the zero level set
                  %our interface is between y & y+1
                  dl = abs(lset(x,y+1));
                  dr = abs(lset(x+1,y+1));
                  offset = dl/(dl+dr);
                  xc = x + offset;
                  t = offset;
                  
                  ph = (x-xc) * (phi(x,y+1)-phi(x+1,y+1)) + phi(x,y+1);
                  px = (x-xc) * (phi_x(x,y+1)-phi_x(x+1,y+1)) + phi_x(x,y+1);
                  py = (x-xc) * (phi_y(x,y+1)-phi_y(x+1,y+1)) + phi_y(x,y+1);
                  
                  et_a = ph + 0.5 * (xc * px +  py * y);
                  extend_this(x-1,y) = et_a;
                  sdist(x-1,y) = -t;
                  sdist(x,y) = dr/(dl+dr);
                  extend_this(x,y) = et_a;
                  %if our interface is between (y+1 & y+2) & (x & x+1) & 
                  %(y & y+1)
                  if((lset(x,y+1)<0) & (lset(x,y+2) >= 0) & (lset(x,y) >=0))
                      dl = abs(lset(x,y+1));
                      dr = abs(lset(x,y+2));
                      dleft = abs(lset(x,y));
                        
                      if(dr>=dleft) %use distance, dtop
                          dr = dleft;
                          s = dl/(dl+dr);
                          yc = y - s;
                          
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x-1,y) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (y-yc) * (phi(x,y)-phi(x,y+1)) + phi(x,y);
                          px = (y-yc) * (phi_x(x,y)-phi_x(x,y+1)) + phi_x(x,y);
                          py = (y-yc) * (phi_y(x,y)-phi_y(x,y+1)) + phi_y(x,y); 
                          et_b = ph + 0.5 * (x * px +  py * yc);
                          extend_this(x-1,y) = (t2 * et_a + s2 * et_b)/(t2+s2);
                          
                      else  %distance dr is smaller, so use it
                               
                          s = dl/(dl+dr);
                          yc = y + s;
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x-1,y) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (y-yc) * (phi(x,y+1)-phi(x,y+2)) + phi(x,y+1);
                          px = (y-yc) * (phi_x(x,y+1)-phi_x(x,y+2)) + phi_x(x,y+1);
                          py = (y-yc) * (phi_y(x,y+1)-phi_y(x,y+2)) + phi_y(x,y+1); 
                          et_b = ph + 0.5 * (x * px +  py * yc);
                          extend_this(x-1,y) = (t2 * et_a + s2 * et_b)/(t2+s2);
                      end
                         
                  end
                  
                  %if our interface is between (x & x+1) & (y & y+1) only
                      if((lset(x,y+1)<0)&(lset(x,y+2)>=0)&(lset(x,y)<0))
                          dl = abs(lset(x,y+1));
                          dr = abs(lset(x,y+2));
                          s = dl/(dl+dr);
                          yc = y + s;
                          s2 = 1/(s^2);
                          t2 = 1/(t^2);
                          sdist(x-1,y) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          ph = (y-yc) * (phi(x,y+1)-phi(x,y+2)) + phi(x,y+1);
                          px = (y-yc) * (phi_x(x,y+1)-phi_x(x,y+2)) + phi_x(x,y+1);
                          py = (y-yc) * (phi_y(x,y+1)-phi_y(x,y+2)) + phi_y(x,y+1); 
                          et_b = ph + 0.5 * (x * px +  py * yc);
                          extend_this(x-1,y) = (t2 * et_a + s2 * et_b)/(t2+s2);
                          
                      end
                  
              end %x<0,x+1>0 
              
          end %end for
    %  end %end for
      
