
function [lset,xco,yco,status_set] = define_lset(C,lset)
[nx,ny] = size(lset);
lset0=lset;
nz = length(C);
%N : inward normal
[N] = get_normal(C,lset);
for x = 1: nx
    for y = 1: ny
        point = [x;y]; % 'x,y or y,x ??'
        [indx,closestpoint,mindist] = getclosest(point,C);
        displace = point - C(:,indx);
        sgn = - sign( displace' * N(:,indx) );  %lset is + outside
        lset(x,y) = sgn * mindist;
    end
end

% get narrow band first time
[xco,yco] = find(abs(lset)<=1.5); %one pixel away from zero level set
int_indx = find(abs(lset)<=1.5);
indx = find(abs(lset)>1.5 & (abs(lset<2.9))); %boundary pixels
status_set = 2*ones(nx,ny);% 2 , in the far area
status_set(int_indx) = 1; %in the narrow band
status_set(indx) = 0; %we are on boundary

% gives new narrow band  w.r.t. current zero level set - width is 6
[xco,yco,zeroset,xc,yc,lset,status_set,nbset] = Find_Narrow_band(lset,status_set,xco,yco,1,6*nz);
%disp('kept longest contour, defined new lset for it')


