
%This function finds the zero level set, GIVEN the coordinates
%of a narrow band around the zero set. It also calcs centroid 
%the new narrow band, and the zero level set points

%use this method when using narrow band evolution of level sets

%Need to either ignore the status set array OR
% FIX IT.
%currently its not being used.

%x = xcoordinates of our narrow band
%y = y-coordinates of our narrow band points
%expand: do you need to find out the narrow band, if yes, pass 1 or else
%pass 0
%xc,yc = centroid location
%zero = zero level set points

function [xco,yco,zero,xc,yc,lset,status_set,nar_x,nar_y,did_we_resize] = Re_initialize_Level(level_set,lset,indx,status_set,x,y,expand, ...
                                                            resize_window_only,dist_func)

   [nx,ny] = size(level_set);
   %first find out if where our zero level set is
   [nsize,dumy] = size(x);
   on_boundary = 0; %assume we havent reached the boundary
   sdist = zeros(nx,ny);
   
 if(resize_window_only ~= 1)
   for k=1:nsize
        lyf.vals = level_set(x(k),y(k)+1);
        lyb.vals = level_set(x(k),y(k)-1);
        lxf.vals = level_set(x(k)+1,y(k));
        lxb.vals = level_set(x(k)-1,y(k));
        lbb.vals = level_set(x(k)-1,y(k)-1);
        lff.vals = level_set(x(k)+1,y(k)+1);
        lyfxb.vals = level_set(x(k)-1,y(k)+1);
        lybxf.vals = level_set(x(k)+1,y(k)-1);
        lv.vals = level_set(x(k),y(k));
        
        lyf.status = status_set(x(k),y(k)+1);
        lyb.status = status_set(x(k),y(k)-1);
        lxf.status = status_set(x(k)+1,y(k));
        lxb.status = status_set(x(k)-1,y(k));
        lbb.status = status_set(x(k)-1,y(k)-1);
        lff.status = status_set(x(k)+1,y(k)+1);
        lyfxb.status = status_set(x(k)-1,y(k)+1);
        lybxf.status = status_set(x(k)+1,y(k)-1);
        lv.status = status_set(x(k),y(k));
        
       if((lyb.vals > 0) & (lv.vals <= 0))
   
             if((lyb.status == 0) | (lv.status == 0))
                 on_boundary = 1; %we are on boundary
             end
                  %calculate speed at the zero level set
                  %our interface is between y & y+1
                  dl = abs(lyb.vals);
                  dr = abs(lv.vals);
                  offset = dl/(dl+dr);
                  t = offset;
                  sdist(x(k),y(k)-1) = t;
                  sdist(x(k),y(k)) = -dr/(dl+dr); %inside the interface, dist is negative
                  
             if((lyb.vals > 0) & (lybxf.vals <= 0) & (lbb.vals <= 0))
                 
                 if ((lyb.status == 0) | (lybxf.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end
                      
                      dr = abs(lybxf.vals);
                      dtop = abs(lbb.vals);
                      if(dr>dtop) %use distance, dtop
                          dr = dtop;    
                      end
                      s = dl/(dl+dr);
                      s2 = 1/(s^2);
                      t2 = 1/(t^2);
                      sdist(x(k),y(k)-1) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          
              end
             
             if((lyb.vals > 0) & (lybxf.vals <= 0) & (lbb.vals > 0))
                 if ((lyb.status == 0) & (lybxf.status == 0) & (lbb.status == 0))
                   on_boundary = 1;
                 end
                      dr = abs(lybxf.vals);
                      s = dl/(dl+dr);
                      s2 = 1/(s^2);
                      t2 = 1/(t^2);
                      sdist(x(k),y(k)-1) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          
             end 
             
       end  %first if      
                 
              
       if((lyb.vals < 0) & (lv.vals >= 0))
           
             if((lyb.status == 0) | (lv.status == 0))
                 on_boundary = 1; %we are on boundary
             end 
                  dl = abs(lyb.vals);
                  dr = abs(lv.vals);
                  offset = dl/(dl+dr);
                  t = offset;
                  sdist(x(k),y(k)-1) = -offset;
                  sdist(x(k),y(k)) = dr/(dl+dr);
                  
             if((lyb.vals < 0) & (lybxf.vals >= 0) & (lbb.vals >= 0))
                 
                 if ((lyb.status == 0) | (lybxf.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                      dr = abs(lybxf.vals);
                      dtop = abs(lbb.vals);
                      if(dr>dtop) %use distance, dtop
                          dr = dtop;
                      end 
                      s = dl/(dl+dr);
                      s2 = 1/(s^2);
                      t2 = 1/(t^2);
                      sdist(x(k),y(k)-1) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                                            
             end 
             
             if((lyb.vals < 0) & ((lybxf.vals >= 0) & (lbb.vals < 0)))
                 if ((lyb.status == 0) | (lybxf.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                      dr = abs(lybxf.vals);
                      s = dl/(dl+dr);
                      s2 = 1/(s^2);
                      t2 = 1/(t^2);
                      sdist(x(k),y(k)-1) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          
             end 
             
       end  %first if      
       
                  
              %case in x direction
              %in this case, we dont consider interface which is covered in
              %one of the above if statements,hence lset(x+1,y+2)<=0
              
       if((lxb.vals > 0) & (lv.vals <= 0) & (lyf.vals <= 0))
   
             if((lxb.status == 0) & (lv.status == 0) & (lyf.status == 0))
                 on_boundary = 1; %we are on boundary
             end 
             %our interface is between y & y+1
                  dl = abs(lxb.vals);
                  dr = abs(lv.vals);
                  offset = dl/(dl+dr);
                  t = offset;
                  sdist(x(k)-1,y(k)) = t;
                  sdist(x(k),y(k)) = -dr/(dl+dr); %dist inside the interface
                  
             if((lxb.vals > 0) & (lyfxb.vals <= 0) & (lbb.vals <= 0))
                 
                 if ((lxb.status == 0) | (lyfxb.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                 dr = abs(lyfxb.vals);
                 dleft = abs(lbb.vals);
                 if(dr>dleft) %use distance, dleft
                      dr = dleft;
                 end  
                  s = dl/(dl+dr);
                  s2 = 1/(s^2);
                  t2 = 1/(t^2);
                  sdist(x(k)-1,y(k)) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          
             end 
             
             if((lxb.vals > 0) & (lyfxb.vals <= 0) & (lbb.vals > 0))
                 if ((lxb.status == 0) | (lyfxb.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                  dr = abs(lyfxb.vals);
                  s = dl/(dl+dr);
                  s2 = 1/(s^2);
                  t2 = 1/(t^2);
                  sdist(x(k)-1,y(k)) = sqrt((s^2 * t^2)/(s^2 + t^2));      
             end 
            
       end  %first if      
                 
              
       if((lxb.vals < 0) & (lv.vals >= 0) & (lyf.vals >= 0))
   
             if((lxb.status == 0) & (lv.status == 0) & (lyf.status == 0))
                 on_boundary = 1; %we are on boundary
             end 
              dl = abs(lxb.vals);
              dr = abs(lv.vals);
              offset = dl/(dl+dr);
              t = offset;
              sdist(x(k)-1,y(k)) = -t;
              sdist(x(k),y(k)) = dr/(dl+dr);
                  
             if((lxb.vals < 0) & (lyfxb.vals >= 0) & (lbb.vals >= 0))
                 
                 if ((lxb.status == 0) | (lyfxb.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                 dr = abs(lyfxb.vals);
                 dleft = abs(lbb.vals);
                 if(dr>=dleft) %use distance, dtop
                   dr = dleft;
                 end 
                  s = dl/(dl+dr);
                  s2 = 1/(s^2);
                  t2 = 1/(t^2);
                  sdist(x(k)-1,y(k)) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          
             end 
             
             if((lxb.vals < 0) & (lyfxb.vals >= 0) & (lbb.vals < 0))
                 if ((lxb.status == 0) | (lyfxb.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                  dr = abs(lyfxb.vals);
                  s = dl/(dl+dr);
                  s2 = 1/(s^2);
                  t2 = 1/(t^2);
                  sdist(x(k)-1,y(k)) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                  
             end 
             
             
       end   %first if   
       
   end  %end for k
   
end % if (resize_window_only~=1)

if(resize_window_only == 2)
  on_boundary = 1; %if we want to re_initialize the level set every time !
end

  if(resize_window_only == 1)
    sdist = dist_func; %we already have the signed distance function, so use it
  end
  [nx,ny] = size(level_set);
  zero = find(sdist~=0);
  [nar_x,nar_y] = find(sdist~=0);
  lset(indx).trans_lset = level_set;
  xc = round(mean(nar_x));
  yc = round(mean(nar_y));
  
%adjust our global centroid according to what we moved now
  lset(indx).vert(5) = xc;
  lset(indx).vert(6) = yc;
  lset(indx).vert(1) = lset(indx).vert(7)+xc;
  lset(indx).vert(2) = lset(indx).vert(8)+yc;
      
  if(resize_window_only == 1)
    [lset,ex,ey,nar_x,nar_y,did_we_resize] = re_adjust_window(lset,indx,nar_x,nar_y,1);
  else
    [lset,ex,ey,nar_x,nar_y,did_we_resize] = re_adjust_window(lset,indx,nar_x,nar_y,0);
  end
  
  if(did_we_resize == 0) %no we didnt
    xco = x;
    yco = y;
  else  %yes we did
    xco = ex;
    yco = ey;
    [nx,ny] = size(lset(indx).trans_lset);
    zset = (yco-1)*nx+xco;
    status_set = zeros(nx,ny);
    status_set(zset) = 1;
    zero = (nar_y-1)*nx+nar_x;
    return;
  end
  
      
  if(on_boundary == 1)
     %store the old vertices, coords
     vert = lset(indx).vert;
     
     [nz,dumy] = size(zero);
     [sdist,ext_zeros] = FastMarching(sdist,zeros(nx,ny),10*nz);
     zset = find(sdist~=0);
     status_set = zeros(nx,ny);
     status_set(zset) = 1;
     [xco,yco] = find(sdist~=0);
     
     %find if our narrow band is at the edge of our small window
     if((~isempty(find(xco<2))) | (~isempty(find(yco<2))) | (~isempty(find(xco>nx-2))) | (~isempty(find(yco>ny-2))))
         [lset,ex,ey,nar_x,nar_y,did_we_resize] = re_adjust_window(lset,indx,nar_x,nar_y,1);
         [nx,ny] = size(lset(indx).trans_lset);
         xco = ex;
         yco = ey;
         zset = (yco-1)*nx+xco;
         status_set = zeros(nx,ny);
         status_set(zset) = 1;
         zero = (nar_y-1)*nx+nar_x;
     else
         %since already have a good signed distance function, just use it to
         %assign to our trans_lset which we can use
         lset(indx).trans_lset = level_set;
         lset(indx).trans_lset(zset) = sign(level_set(zset)) .* sdist(zset);
         lset(indx).I(vert(7):vert(7)+2*vert(3),vert(8):vert(8)+2*vert(4)) = lset(indx).trans_lset;
     end
 end
 
 
 
  