
%This function finds the zero level set, GIVEN the coordinates
%of a narrow band around the zero set. It also calcs centroid 
%the new narrow band, and the zero level set points

%use this method when using narrow band evolution of level sets

%Need to either ignore the status set array OR
% FIX IT.
%currently its not being used.

%x = xcoordinates of our narrow band
%y = y-coordinates of our narrow band points
%expand: do you need to find out the narrow band, if yes, pass 1 or else
%pass 0
%xc,yc = centroid location
%zero = zero level set points

function [xco,yco,zero,xc,yc,level_set,status_set,nbset] = Find_Narrow_band(level_set,status_set,x,y,expand,nbsz)

   [nx,ny] = size(level_set);
   %first find out if where our zero level set is
   [nsize,dumy] = size(x);
   on_boundary = 0; %assume we havent reached the boundary
   sdist = zeros(nx,ny);
   
   for k=1:nsize
        lyf.vals = level_set(x(k),y(k)+1);
        lyb.vals = level_set(x(k),y(k)-1);
        lxf.vals = level_set(x(k)+1,y(k));
        lxb.vals = level_set(x(k)-1,y(k));
        lbb.vals = level_set(x(k)-1,y(k)-1);
        lff.vals = level_set(x(k)+1,y(k)+1);
        lyfxb.vals = level_set(x(k)-1,y(k)+1);
        lybxf.vals = level_set(x(k)+1,y(k)-1);
        lv.vals = level_set(x(k),y(k));
        
        lyf.status = status_set(x(k),y(k)+1);
        lyb.status = status_set(x(k),y(k)-1);
        lxf.status = status_set(x(k)+1,y(k));
        lxb.status = status_set(x(k)-1,y(k));
        lbb.status = status_set(x(k)-1,y(k)-1);
        lff.status = status_set(x(k)+1,y(k)+1);
        lyfxb.status = status_set(x(k)-1,y(k)+1);
        lybxf.status = status_set(x(k)+1,y(k)-1);
        lv.status = status_set(x(k),y(k));
        
       if((lyb.vals > 0) & (lv.vals <= 0))
   
             if((lyb.status == 0) | (lv.status == 0))
                 on_boundary = 1; %we are on boundary
             end
                  %calculate speed at the zero level set
                  %our interface is between y & y+1
                  dl = abs(lyb.vals);
                  dr = abs(lv.vals);
                  offset = dl/(dl+dr);
                  t = offset;
                  sdist(x(k),y(k)-1) = t;
                  sdist(x(k),y(k)) = -dr/(dl+dr); %inside the interface, dist is negative
                  
             if((lyb.vals > 0) & (lybxf.vals <= 0) & (lbb.vals <= 0))
                 
                 if ((lyb.status == 0) | (lybxf.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end
                      
                      dr = abs(lybxf.vals);
                      dtop = abs(lbb.vals);
                      if(dr>dtop) %use distance, dtop
                          dr = dtop;    
                      end
                      s = dl/(dl+dr);
                      s2 = 1/(s^2);
                      t2 = 1/(t^2);
                      sdist(x(k),y(k)-1) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          
              end
             
             if((lyb.vals > 0) & (lybxf.vals <= 0) & (lbb.vals > 0))
                 if ((lyb.status == 0) & (lybxf.status == 0) & (lbb.status == 0))
                   on_boundary = 1;
                 end
                      dr = abs(lybxf.vals);
                      s = dl/(dl+dr);
                      s2 = 1/(s^2);
                      t2 = 1/(t^2);
                      sdist(x(k),y(k)-1) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          
             end 
             
       end  %first if      
                 
              
       if((lyb.vals < 0) & (lv.vals >= 0))
           
             if((lyb.status == 0) | (lv.status == 0))
                 on_boundary = 1; %we are on boundary
             end 
                  dl = abs(lyb.vals);
                  dr = abs(lv.vals);
                  offset = dl/(dl+dr);
                  t = offset;
                  sdist(x(k),y(k)-1) = -offset;
                  sdist(x(k),y(k)) = dr/(dl+dr);
                  
             if((lyb.vals < 0) & (lybxf.vals >= 0) & (lbb.vals >= 0))
                 
                 if ((lyb.status == 0) | (lybxf.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                      dr = abs(lybxf.vals);
                      dtop = abs(lbb.vals);
                      if(dr>dtop) %use distance, dtop
                          dr = dtop;
                      end 
                      s = dl/(dl+dr);
                      s2 = 1/(s^2);
                      t2 = 1/(t^2);
                      sdist(x(k),y(k)-1) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                                            
             end 
             
             if((lyb.vals < 0) & ((lybxf.vals >= 0) & (lbb.vals < 0)))
                 if ((lyb.status == 0) | (lybxf.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                      dr = abs(lybxf.vals);
                      s = dl/(dl+dr);
                      s2 = 1/(s^2);
                      t2 = 1/(t^2);
                      sdist(x(k),y(k)-1) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          
             end 
             
       end  %first if      
       
                  
              %case in x direction
              %in this case, we dont consider interface which is covered in
              %one of the above if statements,hence lset(x+1,y+2)<=0
              
       if((lxb.vals > 0) & (lv.vals <= 0) & (lyf.vals <= 0))
   
             if((lxb.status == 0) & (lv.status == 0) & (lyf.status == 0))
                 on_boundary = 1; %we are on boundary
             end 
             %our interface is between y & y+1
                  dl = abs(lxb.vals);
                  dr = abs(lv.vals);
                  offset = dl/(dl+dr);
                  t = offset;
                  sdist(x(k)-1,y(k)) = t;
                  sdist(x(k),y(k)) = -dr/(dl+dr); %dist inside the interface
                  
             if((lxb.vals > 0) & (lyfxb.vals <= 0) & (lbb.vals <= 0))
                 
                 if ((lxb.status == 0) | (lyfxb.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                 dr = abs(lyfxb.vals);
                 dleft = abs(lbb.vals);
                 if(dr>dleft) %use distance, dleft
                      dr = dleft;
                 end  
                  s = dl/(dl+dr);
                  s2 = 1/(s^2);
                  t2 = 1/(t^2);
                  sdist(x(k)-1,y(k)) = sqrt((s^2 * t^2)/(s^2 + t^2));
                          
             end 
             
             if((lxb.vals > 0) & (lyfxb.vals <= 0) & (lbb.vals > 0))
                 if ((lxb.status == 0) | (lyfxb.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                  dr = abs(lyfxb.vals);
                  s = dl/(dl+dr);
                  s2 = 1/(s^2);
                  t2 = 1/(t^2);
                  sdist(x(k)-1,y(k)) = sqrt((s^2 * t^2)/(s^2 + t^2));      
             end 
            
       end  %first if      
                 
              
       if((lxb.vals < 0) & (lv.vals >= 0) & (lyf.vals >= 0))
   
             if((lxb.status == 0) & (lv.status == 0) & (lyf.status == 0))
                 on_boundary = 1; %we are on boundary
             end 
              dl = abs(lxb.vals);
              dr = abs(lv.vals);
              offset = dl/(dl+dr);
              t = offset;
              sdist(x(k)-1,y(k)) = -t;
              sdist(x(k),y(k)) = dr/(dl+dr);
                  
             if((lxb.vals < 0) & (lyfxb.vals >= 0) & (lbb.vals >= 0))
                 
                 if ((lxb.status == 0) | (lyfxb.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                 dr = abs(lyfxb.vals);
                 dleft = abs(lbb.vals);
                 if(dr>=dleft) %use distance, dtop
                   dr = dleft;
                 end 
                  s = dl/(dl+dr);
                  s2 = 1/(s^2);
                  t2 = 1/(t^2);
                  sdist(x(k)-1,y(k)) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                          
             end 
             
             if((lxb.vals < 0) & (lyfxb.vals >= 0) & (lbb.vals < 0))
                 if ((lxb.status == 0) | (lyfxb.status == 0) | (lbb.status == 0))
                   on_boundary = 1;
                 end 
                  dr = abs(lyfxb.vals);
                  s = dl/(dl+dr);
                  s2 = 1/(s^2);
                  t2 = 1/(t^2);
                  sdist(x(k)-1,y(k)) = -sqrt((s^2 * t^2)/(s^2 + t^2));
                  
             end 
             
             
       end   %first if   
       
   end  %end for k
  

  [nx,ny] = size(level_set);
  zero = find(sdist~=0);
  [nar_x,nar_y] = find(sdist~=0);
  if ~isempty(nar_x)
      xc = round(mean(nar_x));
      yc = round(mean(nar_y));
  else
      xc = inf; yc = inf; keyboard, disp('empty nar_x, nar_y in Find_Narrow_band')
  end
  
  if ((expand == 1)|(on_boundary == 1))
     [nz,dumy] = size(zero);
     [sdist,ext_zeros] = FastMarching(sdist,zeros(nx,ny),nbsz);
     nbset = find(sdist~=0);
     [xco,yco] = find(sdist~=0);
     level_set(nbset) = sign(level_set(nbset)) .* sdist(nbset);
 end
 
 
  
  