% This function does Fast Marching to find an extension
% for the stopping term
% The inputs are
%dist_func : a temporary distance function obtained from
% the funciton "FastMarch_initialize.m
%phi_hat: the term you want to extend

%If you are debugging this code, remember the x-y axis are 
%differnt than our usual ones. this is bcoz matlab stores
%the array that way

function [sdist,extension] = FastMarching2D(dist_func,phi_hat,iterations)
 [nx,ny] = size(dist_func);
 sdist = dist_func;
 extension = phi_hat;
 
 
 curr_sign = 1;
  
 pindx = find(dist_func<0);
 dist_func(pindx) = -dist_func(pindx);
 sdist = dist_func;
 %find points that are non-zero. these are our initial known points
 [R,C] = find(dist_func~=0);
 
 %if we are on boundary, move it a bit, shoudlnt do this, but its a temporary fix
 ix = find(R<=2);
 if(~isempty(ix))
   R(ix) = 3;
 end
 ix = find(C<=2);
 if(~isempty(ix))
   C(ix) = 3;
 end
 
 zindx = find(sdist == 0);
 %set all othe points to infinity, here it is 1e5
 sdist(zindx) = 1e5;
 
 Trial_grid = zeros(nx,ny); %store the index of Trial_val
  %indicating that this val is also a Trial point for
  %for some other point
 
 
 %iterations = 1500;
 
 c=1;
    
 for i = 1:length(R)
     %find trial points, one grid point away from known points
     %also calculate values at these trial points
     if((sdist(R(i)+1,C(i))==1e5)&(Trial_grid(R(i)+1,C(i))==0))
         %push these co-ordinates into an array so that we can
         %iterate later on to find the T vals at these points
         if(((R(i)+2)>nx)|((C(i)-1)<=0)|((C(i)+1)>ny))
             continue;
         end
             
         Trial_R(c) = R(i)+1;
         Trial_C(c) = C(i);
         %mark as trial point
         Trial_grid(R(i)+1,C(i))=c;
         
         k = sdist(R(i)+1,C(i)); %current trial point
         k_up = sdist(R(i),C(i));
         k_down = sdist(R(i)+2,C(i));
         k_left = sdist(R(i)+1,C(i)-1);
         k_right = sdist(R(i)+1,C(i)+1);
         k1 = 0;
         k2 = 0;
         ph1 = 0;
         ph2 = 0;
         A = 0;
         xm = 0;
         xp = 0;
         ym = 0;
         yp = 0;
         
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         
         %do upwind differncing. Use only the largest solution
         denom = 0;
         if((curr_sign*Dxm > 0) | (curr_sign*Dxp < 0))
             if(curr_sign*Dxm > -curr_sign*Dxp)
                 k2 = -curr_sign*k_up;
                 A = A+1;
                 xm = 1;
             else
                 k2 = -curr_sign*k_down;
                 A = A+1;
                 xp = 1;
             end
         end
         if((curr_sign*Dym > 0) | (curr_sign*Dyp < 0))
             if(curr_sign*Dym > -curr_sign*Dyp)
                 k1 = -curr_sign*k_left;
                 A = A+1;
                 ym = 1;
             else
                 k1 = -curr_sign*k_right;
                 A = A+1;
                 yp = 1;
             end
         end
         
         if(A==0)
             %we shouldnt enter here....
             ext_temp(c) = extension(R(i),C(i));
             c=c+1;
             fprintf('A==0');
             continue;
         end
         
         disc = 4*(k1+k2)^2-4*A*(k1^2+k2^2-1);
         
         if(disc < 0)
            Trial_val(c) = -curr_sign*2*(k1+k2)/(2*A);
         else
            Trial_val(c) = curr_sign*(-2*(k1+k2)+sqrt(disc))/(2*A);
         end
         %now compute our extension based on this newly computed
         %distance. Use only those points in our computation
         %of extension, which we used to compute this distance
         %hence we have the xm=1,yp=1....stuff above in our
         %if loops
         k = Trial_val(c);
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         
         
         %see notes on this. Evolve based on the eqn: px*lx + py*ly=0
         if(A == 2)
             if((xp==1)&(ym==1))
                 ym = -1;
             end
             if((xm==1)&(yp==1))
                 xm = -1;
             end
         end %A==2
         
         ph = extension(R(i),C(i))*Dxm*xm + extension(R(i)+2,C(i))*Dxp*xp + ...
                  extension(R(i)+1,C(i)-1)*Dym*ym + extension(R(i)+1,C(i)+1)*Dyp*yp;
         denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
             
         if(abs(denom) >= 0.001)       
             ext_temp(c) = (ph)/denom;
         else
             ext_temp(c) = extension(R(i),C(i));
         end
         
         c=c+1;
     end
     
     %do as above for all the neighbors of our current triaa point
     
     if((sdist(R(i)-1,C(i))==1e5)&(Trial_grid(R(i)-1,C(i))==0))
         if(((R(i)-2)<=0)|((C(i)-1)<=0)|((C(i)+1)>ny))
             continue;
         end
         
         Trial_R(c) = R(i)-1;
         Trial_C(c) = C(i);
         Trial_grid(R(i)-1,C(i))=c;
         k1 = 0;
         k2 = 0;
         ph1 = 0;
         ph2 = 0;
         A=0;
         xm = 0;
         xp = 0;
         ym = 0;
         yp = 0;
         k = sdist(R(i)-1,C(i)); %current trial point
         k_up = sdist(R(i)-2,C(i));
         k_down = sdist(R(i),C(i));
         k_left = sdist(R(i)-1,C(i)-1);
         k_right = sdist(R(i)-1,C(i)+1);
         
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         
         
         denom = 0;
         if((curr_sign*Dxm > 0) | (curr_sign*Dxp < 0))
             if(curr_sign*Dxm > -curr_sign*Dxp)
                 k2 = -curr_sign*k_up;
                 A = A+1;
                 xm = 1;
             else
                 k2 = -curr_sign*k_down;
                 A = A+1;
                 xp = 1;
             end
         end
         if((curr_sign*Dym > 0) | (curr_sign*Dyp < 0))
             if(curr_sign*Dym > -curr_sign*Dyp)
                 k1 = -curr_sign*k_left;
                 A = A+1;
                 ym = 1;
             else
                 k1 = -curr_sign*k_right;
                 A = A+1;
                 yp = 1;
             end
         end
            
         if(A==0)
             ext_temp(c) = extension(R(i),C(i));
             c=c+1;
             fprintf('A==0');
             continue;
         end
         disc = 4*(k1+k2)^2-4*A*(k1^2+k2^2-1);
         
         if(disc < 0)
            Trial_val(c) = -curr_sign*2*(k1+k2)/(2*A);
         else
            Trial_val(c) = curr_sign*(-2*(k1+k2)+sqrt(disc))/(2*A);
         end
         k = Trial_val(c);
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         
         
         %see notes on this. Evolve based on the eqn: px*lx + py*ly=0
         if(A == 2)
             if((xp==1)&(ym==1))
                 ym = -1;
             end
             if((xm==1)&(yp==1))
                 xm = -1;
             end
         end %A==2
         denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
         
         ph = extension(R(i)-2,C(i))*Dxm*xm + extension(R(i),C(i))*Dxp*xp + ...
              extension(R(i)-1,C(i)-1)*Dym*ym + extension(R(i)-1,C(i)+1)*Dyp*yp;
         
         if(abs(denom) >= 0.001)    
             ext_temp(c) = (ph)/denom;
         else
             ext_temp(c) = extension(R(i),C(i));
         end
         c=c+1;
         
     end
     
     if((sdist(R(i),C(i)+1)==1e5)&(Trial_grid(R(i),C(i)+1)==0))
         if(((R(i)+1)>nx)|((R(i)-1)<=0)|((C(i)+2)>ny))
             continue;
         end
         Trial_R(c) = R(i);
         Trial_C(c) = C(i)+1;
         Trial_grid(R(i),C(i)+1)=c;
         k1 = 0;
         k2 = 0;
         ph1 = 0;
         ph2 = 0;
         A=0;
         xm = 0;
         xp = 0;
         ym = 0;
         yp = 0;
         k = sdist(R(i),C(i)+1); %current trial point
         k_up = sdist(R(i)-1,C(i)+1);
         k_down = sdist(R(i)+1,C(i)+1);
         k_left = sdist(R(i),C(i));
         k_right = sdist(R(i),C(i)+2);
         
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         denom = 0.00;
         
         if((curr_sign*Dxm > 0) | (curr_sign*Dxp < 0))
             if(curr_sign*Dxm > -curr_sign*Dxp)
                 k2 = -curr_sign*k_up;
                 A = A+1;
                 xm = 1;
             else
                 k2 = -curr_sign*k_down;
                 A = A+1;
                 xp = 1;
             end
         end
         if((curr_sign*Dym > 0) | (curr_sign*Dyp < 0))
             if(curr_sign*Dym > -curr_sign*Dyp)
                 k1 = -curr_sign*k_left;
                 A = A+1;
                 ym = 1;
             else
                 k1 = -curr_sign*k_right;
                 A = A+1;
                 yp = 1;
             end
         end
            
         if(A==0)
             ext_temp(c) = extension(R(i),C(i));
             c=c+1;
             fprintf('A==0');
             continue;
         end
         
         disc = 4*(k1+k2)^2-4*A*(k1^2+k2^2-1);
         
         if(disc < 0)
            Trial_val(c) = -curr_sign*2*(k1+k2)/(2*A);
         else
            Trial_val(c) = curr_sign*(-2*(k1+k2)+sqrt(disc))/(2*A);
         end
         k = Trial_val(c);
         
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         
         %see notes on this. Evolve based on the eqn: px*lx + py*ly=0
         if(A == 2)
             if((xp==1)&(ym==1))
                 ym = -1;
             end
             if((xm==1)&(yp==1))
                 xm = -1;
             end
         end %A==2
         
         denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
         
         ph = extension(R(i)-1,C(i)+1)*Dxm*xm + extension(R(i)+1,C(i)+1)*Dxp*xp + ...
              extension(R(i),C(i))*Dym*ym + extension(R(i),C(i)+2)*Dyp*yp;
         
         if(abs(denom) >= 0.001)    
             ext_temp(c) = (ph)/denom;
         else
             ext_temp(c) = extension(R(i),C(i));
         end
         c=c+1;
     end
     
     if((sdist(R(i),C(i)-1)==1e5)&(Trial_grid(R(i),C(i)-1)==0))
         if(((R(i)+1)>nx)|((C(i)-2)<=0)|((R(i)-1)<=0))
             continue;
         end
         Trial_R(c) = R(i);
         Trial_C(c) = C(i)-1;
         Trial_grid(R(i),C(i)-1)=c;
         k1 = 0;
         k2 = 0;
         ph1 = 0;
         ph2 = 0;
         A=0;
         xm = 0;
         xp = 0;
         ym = 0;
         yp = 0;
         k = sdist(R(i),C(i)-1); %current trial point
         k_up = sdist(R(i)-1,C(i)-1);
         k_down = sdist(R(i)+1,C(i)-1);
         k_left = sdist(R(i),C(i)-2);
         k_right = sdist(R(i),C(i));
         
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         denom = 0.00;
         
         if((curr_sign*Dxm > 0) | (curr_sign*Dxp < 0))
             if(curr_sign*Dxm > -curr_sign*Dxp)
                 k2 = -curr_sign*k_up;
                 A = A+1;
                 xm = 1;
             else
                 k2 = -curr_sign*k_down;
                 A = A+1;
                 xp = 1;
             end
         end
         if((curr_sign*Dym > 0) | (curr_sign*Dyp < 0))
             if(curr_sign*Dym > -curr_sign*Dyp)
                 k1 = -curr_sign*k_left;
                 A = A+1;
                 ym = 1;
             else
                 k1 = -curr_sign*k_right;
                 A = A+1;
                 yp = 1;
             end
         end
            
         if(A==0)
             ext_temp(c) = extension(R(i),C(i));
             c=c+1;
             fprintf('A==0');
             continue;
         end
         
         disc = 4*(k1+k2)^2-4*A*(k1^2+k2^2-1);
         
         if(disc < 0)
            Trial_val(c) = -curr_sign*2*(k1+k2)/(2*A);
         else
            Trial_val(c) = curr_sign*(-2*(k1+k2)+sqrt(disc))/(2*A);
         end
         k = Trial_val(c);
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         %see notes on this. Evolve based on the eqn: px*lx + py*ly=0
         if(A == 2)
             if((xp==1)&(ym==1))
                 ym = -1;
             end
             if((xm==1)&(yp==1))
                 xm = -1;
             end
         end %A==2
         
         denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
            
         ph = extension(R(i)-1,C(i)-1)*Dxm*xm + extension(R(i)+1,C(i)-1)*Dxp*xp + ...
              extension(R(i),C(i)-2)*Dym*ym + extension(R(i),C(i))*Dyp*yp;
             
         if(abs(denom) >= 0.001)    
             ext_temp(c) = (ph)/denom;
         else
             ext_temp(c) = extension(R(i),C(i));
         end
         
         c=c+1;
     end
     
     
 end %end for
 
 %-------------------------------------------------------------------------
 %-------------------------------------------------------------------------
 
  BIG = curr_sign*500;
  
  
  
  %find the smallest point among these and make it known
  for iter = 1:iterations
      
    [val,indx] = min(abs(Trial_val));
    sdist(Trial_R(indx),Trial_C(indx)) = Trial_val(indx);
    extension(Trial_R(indx),Trial_C(indx)) = ext_temp(indx);
    %fprintf('t = %d, indx = %d\n',ext_temp(indx),indx);
  
     %this val is now known, so we dont need it anymore
     Trial_val(indx) = BIG;
     
        
    %find the nghrs of this val and add to trial list
     curr_r = Trial_R(indx);
     curr_c = Trial_C(indx);
     
     if(sdist(curr_r+1,curr_c)==1e5)
         if((curr_r+2 > nx) | (curr_c-1 <=0) | (curr_c+1 > ny))
             continue;
         end
         
         k = sdist(curr_r+1,curr_c); %current trial point
         k_up = sdist(curr_r,curr_c);
         k_down = sdist(curr_r+2,curr_c);
         k_left = sdist(curr_r+1,curr_c-1);
         k_right = sdist(curr_r+1,curr_c+1);
         k1 = 0;
         k2 = 0;
         ph1 = 0;
         ph2 = 0;
         A=0;
         xm = 0;
         xp = 0;
         ym = 0;
         yp = 0;
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         
         
         denom = 0;
         if((curr_sign*Dxm > 0) | (curr_sign*Dxp < 0))
             if(curr_sign*Dxm > -curr_sign*Dxp)
                 k2 = -curr_sign*k_up;
                 A = A+1;
                 xm = 1;
             else
                 k2 = -curr_sign*k_down;
                 A = A+1;
                 xp = 1;
             end
         end
         if((curr_sign*Dym > 0) | (curr_sign*Dyp < 0))
             if(curr_sign*Dym > -curr_sign*Dyp)
                 k1 = -curr_sign*k_left;
                 A = A+1;
                 ym = 1;
             else
                 k1 = -curr_sign*k_right;
                 A = A+1;
                 yp = 1;
             end
         end
            
         if(A==0)
             %ext_temp = [ext_temp extension(curr_r,curr_c)];
             fprintf('A==0');
             continue;
         end
         
         disc = 4*(k1+k2)^2-4*A*(k1^2+k2^2-1);
         
         if(disc < 0)
            k = -curr_sign*2*(k1+k2)/(2*A);
         else
            k = curr_sign*(-2*(k1+k2)+sqrt(disc))/(2*A);
         end
         
         %see notes for details
         if(A == 2)
             if((xp==1)&(ym==1))
                 ym = -1;
             end
             if((xm==1)&(yp==1))
                 xm = -1;
             end
         end %A==2
         
         %find if this point is already a Trial point & if so, choose the
         %smallest value
         tmp = Trial_grid(curr_r+1,curr_c);
         
         if(tmp ~= 0) %we have computed this val before
             if(k < Trial_val(tmp)) %calc only if new val is smaller
                 Trial_val(tmp) = k;
                 Dxm = k - k_up;
                 Dxp = k_down - k;
                 Dym = k - k_left;
                 Dyp = k_right-k;
                 denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
         
                 if(abs(denom) >= 0.001)
             
                 ph = extension(curr_r,curr_c)*Dxm*xm + extension(curr_r+2,curr_c)*Dxp*xp + ...
                      extension(curr_r+1,curr_c-1)*Dym*ym + extension(curr_r+1,curr_c+1)*Dyp*yp;
                       
                     ext_temp(tmp) = (ph)/denom;
                 else
                     ext_temp(tmp) =  extension(curr_r,curr_c);
                 end
                 
             end
                 
         else %we havent computed this trial val before
             Trial_val = [Trial_val k];
             Trial_R = [Trial_R curr_r+1];
             Trial_C = [Trial_C curr_c];
             [z,c] = size(Trial_val);
             Trial_grid(curr_r+1,curr_c) = c; %last val is the index
             
             Dxm = k - k_up;
             Dxp = k_down - k;
             Dym = k - k_left;
             Dyp = k_right-k;
             denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
             
             if(abs(denom) >= 0.01)
                 
                 ph = extension(curr_r,curr_c)*Dxm*xm + extension(curr_r+2,curr_c)*Dxp*xp + ...
                      extension(curr_r+1,curr_c-1)*Dym*ym + extension(curr_r+1,curr_c+1)*Dyp*yp;
                 
                 ext_temp = [ext_temp (ph)/denom];
             else
                 ext_temp = [ext_temp extension(curr_r,curr_c)];
             end
         end
         
       
         %c=c+1;
     end
     
     if(sdist(curr_r-1,curr_c)==1e5)
         
         k1 = 0;
         k2 = 0;
         ph1 = 0;
         ph2 = 0;
         A=0;
         xm = 0;
         xp = 0;
         ym = 0;
         yp = 0;
         if((curr_r-2 <= 0) | (curr_c-1 <=0) | (curr_c+1 > ny))
             continue;
         end
         
         k = sdist(curr_r-1,curr_c); %current trial point
         k_up = sdist(curr_r-2,curr_c);
         k_down = sdist(curr_r,curr_c);
         k_left = sdist(curr_r-1,curr_c-1);
         k_right = sdist(curr_r-1,curr_c+1);
         
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         denom = 0;
         
         if((curr_sign*Dxm > 0) | (curr_sign*Dxp < 0))
             if(curr_sign*Dxm > -curr_sign*Dxp)
                 k2 = -curr_sign*k_up;
                 A = A+1;
                 xm = 1;
             else
                 k2 = -curr_sign*k_down;
                 A = A+1;
                 xp =1;
             end
         end
         if((curr_sign*Dym > 0) | (curr_sign*Dyp < 0))
             if(curr_sign*Dym > -curr_sign*Dyp)
                 k1 = -curr_sign*k_left;
                 A = A+1;
                 ym =1;
             else
                 k1 = -curr_sign*k_right;
                 A = A+1;
                 yp=1;
             end
         end
            
         if(A==0)
    %         ext_temp = [ext_temp extension(curr_r,curr_c)];
             fprintf('A==0');
             continue;
         end
         
         disc = 4*(k1+k2)^2-4*A*(k1^2+k2^2-1);
         
         if(disc < 0)
            k = -curr_sign*2*(k1+k2)/(2*A);
         else
            k = curr_sign*(-2*(k1+k2)+sqrt(disc))/(2*A);
         end

         if(A == 2)
             if((xp==1)&(ym==1))
                 ym = -1;
             end
             if((xm==1)&(yp==1))
                 xm = -1;
             end
         end %A==2
         
         tmp = Trial_grid(curr_r-1,curr_c);
         
         if(tmp ~= 0) %we have computed this val before
             if(k < Trial_val(tmp)) %calc only if new val is smaller
                 Trial_val(tmp) = k;
                 Dxm = k - k_up;
                 Dxp = k_down - k;
                 Dym = k - k_left;
                 Dyp = k_right-k;
                 denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
         
                 if(abs(denom) >= 0.001)
             
                 ph = extension(curr_r-2,curr_c)*Dxm*xm + extension(curr_r,curr_c)*Dxp*xp + ...
                      extension(curr_r-1,curr_c-1)*Dym*ym + extension(curr_r-1,curr_c+1)*Dyp*yp;
                       
                     ext_temp(tmp) = (ph)/denom;
                 else
                     ext_temp(tmp) =  extension(curr_r,curr_c);
                 end
                 
             end
                 
         else %we havent computed this trial val before
             Trial_val = [Trial_val k];
             Trial_R = [Trial_R curr_r-1];
             Trial_C = [Trial_C curr_c];
             [z,c] = size(Trial_val);
             Trial_grid(curr_r-1,curr_c) = c; %last val is the index
             
             Dxm = k - k_up;
             Dxp = k_down - k;
             Dym = k - k_left;
             Dyp = k_right-k;
             denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
             
             if(abs(denom) >= 0.01)
                 
                 ph = extension(curr_r-2,curr_c)*Dxm*xm + extension(curr_r,curr_c)*Dxp*xp + ...
                      extension(curr_r-1,curr_c-1)*Dym*ym + extension(curr_r-1,curr_c+1)*Dyp*yp;
                 
                 ext_temp = [ext_temp (ph)/denom];
             else
                 ext_temp = [ext_temp extension(curr_r,curr_c)];
             end
         end
         
     end
     
     if(sdist(curr_r,curr_c+1)==1e5)
         
         k1 = 0;
         k2 = 0;
         ph1 = 0;
         ph2 = 0;
         A=0;
         xm = 0;
         xp = 0;
         ym = 0;
         yp = 0;
         if((curr_r+1 > nx) | (curr_c+2 > ny) | (curr_c+1 > ny))
             continue;
         end
         k = sdist(curr_r,curr_c+1); %current trial point
         k_up = sdist(curr_r-1,curr_c+1);
         k_down = sdist(curr_r+1,curr_c+1);
         k_left = sdist(curr_r,curr_c);
         k_right = sdist(curr_r,curr_c+2);
         
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         denom = 0.00;
         
         
         if((curr_sign*Dxm > 0) | (curr_sign*Dxp < 0))
             if(curr_sign*Dxm > -curr_sign*Dxp)
                 k2 = -curr_sign*k_up;
                 A = A+1;
                 xm=1;
             else
                 k2 = -curr_sign*k_down;
                 A = A+1;
                 xp=1;
             end
         end
         if((curr_sign*Dym > 0) | (curr_sign*Dyp < 0))
             if(curr_sign*Dym > -curr_sign*Dyp)
                 k1 = -curr_sign*k_left;
                 A = A+1;
                 ym=1;
             else
                 k1 = -curr_sign*k_right;
                 A = A+1;
                 yp=1;
             end
         end
            
         if(A==0)
             %ext_temp = [ext_temp extension(curr_r,curr_c)];
             fprintf('A==0');
             continue;
         end
         
         disc = 4*(k1+k2)^2-4*A*(k1^2+k2^2-1);
         
         if(disc < 0)
            k = -curr_sign*2*(k1+k2)/(2*A);
         else
            k = curr_sign*(-2*(k1+k2)+sqrt(disc))/(2*A);
         end
         
         if(A == 2)
             if((xp==1)&(ym==1))
                 ym = -1;
             end
             if((xm==1)&(yp==1))
                 xm = -1;
             end
         end %A==2
         
         tmp = Trial_grid(curr_r,curr_c+1);
 
         if(tmp ~= 0) %we have computed this val before
             if(k < Trial_val(tmp)) %calc only if new val is smaller
                 Trial_val(tmp) = k;
                 Dxm = k - k_up;
                 Dxp = k_down - k;
                 Dym = k - k_left;
                 Dyp = k_right-k;
                 denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
         
                 if(abs(denom) >= 0.001)
             
                 ph = extension(curr_r-1,curr_c+1)*Dxm*xm + extension(curr_r+1,curr_c+1)*Dxp*xp + ...
                  extension(curr_r,curr_c)*Dym*ym + extension(curr_r,curr_c+2)*Dyp*yp;
                       
                     ext_temp(tmp) = (ph)/denom;
                 else
                     ext_temp(tmp) =  extension(curr_r,curr_c);
                 end
                 
             end
                 
         else %we havent computed this trial val before
             Trial_val = [Trial_val k];
             Trial_R = [Trial_R curr_r];
             Trial_C = [Trial_C curr_c+1];
             [z,c] = size(Trial_val);
             Trial_grid(curr_r,curr_c+1) = c; %last val is the index
             
             Dxm = k - k_up;
             Dxp = k_down - k;
             Dym = k - k_left;
             Dyp = k_right-k;
             denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
             
             if(abs(denom) >= 0.01)
                 
                 ph = extension(curr_r-1,curr_c+1)*Dxm*xm + extension(curr_r+1,curr_c+1)*Dxp*xp + ...
                  extension(curr_r,curr_c)*Dym*ym + extension(curr_r,curr_c+2)*Dyp*yp;
                 
                 ext_temp = [ext_temp (ph)/denom];
             else
                 ext_temp = [ext_temp extension(curr_r,curr_c)];
             end
         end
         
     end %end if
     
     if(sdist(curr_r,curr_c-1)==1e5)
         
         k1 = 0;
         k2 = 0;
         ph1 = 0;
         ph2 = 0;
         A=0;
         xm = 0;
         xp = 0;
         ym = 0;
         yp = 0;
         if((curr_r+1 > nx) | (curr_c-2 <=0) | (curr_c-1 <= 0))
             continue;
         end
         
         k = sdist(curr_r,curr_c-1); %current trial point
         k_up = sdist(curr_r-1,curr_c-1);
         k_down = sdist(curr_r+1,curr_c-1);
         k_left = sdist(curr_r,curr_c-2);
         k_right = sdist(curr_r,curr_c);
         
         Dxm = k - k_up;
         Dxp = k_down - k;
         Dym = k - k_left;
         Dyp = k_right-k;
         denom = 0.00;
         
         if((curr_sign*Dxm > 0) | (curr_sign*Dxp < 0))
             if(curr_sign*Dxm > -curr_sign*Dxp)
                 k2 = -curr_sign*k_up;
                 A = A+1;
                 xm = 1;
             else
                 k2 = -curr_sign*k_down;
                 A = A+1;
                 xp = 1;
             end
         end
         if((curr_sign*Dym > 0) | (curr_sign*Dyp < 0))
             if(curr_sign*Dym > -curr_sign*Dyp)
                 k1 = -curr_sign*k_left;
                 A = A+1;
                 ym=1;
             else
                 k1 = -curr_sign*k_right;
                 A = A+1;
                 yp=1;
             end
         end
            
         if(A==0)
             %ext_temp = [ext_temp extension(curr_r,curr_c)];
             fprintf('A==0');
             continue;
         end
         
         disc = 4*(k1+k2)^2-4*A*(k1^2+k2^2-1);
         
         if(disc < 0)
            k = -curr_sign*2*(k1+k2)/(2*A);
         else
            k = curr_sign*(-2*(k1+k2)+sqrt(disc))/(2*A);
         end
         
         if(A == 2)
             if((xp==1)&(ym==1))
                 ym = -1;
             end
             if((xm==1)&(yp==1))
                 xm = -1;
             end
         end %A==2
         
         tmp = Trial_grid(curr_r,curr_c-1);
         
         if(tmp ~= 0) %we have computed this val before
             if(k < Trial_val(tmp)) %calc only if new val is smaller
                 Trial_val(tmp) = k;
                 Dxm = k - k_up;
                 Dxp = k_down - k;
                 Dym = k - k_left;
                 Dyp = k_right-k;
                 denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
         
                 if(abs(denom) >= 0.001)
             
                 ph = extension(curr_r-1,curr_c-1)*Dxm*xm + extension(curr_r+1,curr_c-1)*Dxp*xp + ...
                  extension(curr_r,curr_c-2)*Dym*ym + extension(curr_r,curr_c)*Dyp*yp;
                       
                     ext_temp(tmp) = (ph)/denom;
                 else
                     ext_temp(tmp) =  extension(curr_r,curr_c);
                 end
                 
             end
                 
         else %we havent computed this trial val before
             Trial_val = [Trial_val k];
             Trial_R = [Trial_R curr_r];
             Trial_C = [Trial_C curr_c-1];
             [z,c] = size(Trial_val);
             Trial_grid(curr_r,curr_c-1) = c; %last val is the index
             
             Dxm = k - k_up;
             Dxp = k_down - k;
             Dym = k - k_left;
             Dyp = k_right-k;
             denom = Dxm*xm+Dxp*xp+Dym*ym+Dyp*yp;
             
             if(abs(denom) >= 0.01)
                 
                 ph = extension(curr_r-1,curr_c-1)*Dxm*xm + extension(curr_r+1,curr_c-1)*Dxp*xp + ...
                  extension(curr_r,curr_c-2)*Dym*ym + extension(curr_r,curr_c)*Dyp*yp;
                 
                 ext_temp = [ext_temp (ph)/denom];
             else
                 ext_temp = [ext_temp extension(curr_r,curr_c)];
             end
         end
         
     %c=c+1;
     end
           
  
  end %iterations

clear Trial_val;
clear ext_temp;
clear Trial_R;
clear Trial_C;
zindx = find(sdist == 1e5);
sdist(zindx) = 0;

%imshow(uint8(100*abs(extension)));
