
%gendata_2obj

t = 3;
C = state2(t).C;
C2 = state2(t+1).C;
knotloc_moved = state2(t).knotloc_moved;
Cvel_basis = state2(t).Cvel_basis;
K = length(state2(t).Cvel_basis)
Mt=length(C)
L = Mt;
[C,Cvel,knotloc,knotindx,N,Cdot_basis]  = get_velocity(C,K,0,knotloc_moved,Cvel_basis,lset);

[arclen] = get_arclength(C);
len = arclen(end);
L =  floor(len);
[Cvel_unif] = interp1(arclen/len, Cvel, [1:L]/L,'cubic','extrap');

Cdef = Cvel_unif;       %Cvelt2{t}; %
[N,T,sgn,normdCdp] = get_normal(C,lset);

Cv = Cdef ; %.*normdCdp;

'use fft instead of freqz'
N = 1024;
fmax1 = K/(2*L);
fmax2 = 1.3*K/(2*L);
H = fft(Cv,N); Hn = H/max(abs(H));
h = ifft(H); ff = [0: (1/N): 1-1e-15];
plot(Cv/max(abs(Cv))), hold on
plot(real(h(1:L))/max(abs(real(h(1:L))) ),'k--'), hold on,

Hbox1 = ( (ff<=fmax1) | (ff>=(1-fmax1)) );
Hfilt = H.* Hbox1 ;
hfilt=ifft(Hfilt); 
plot(real(hfilt(1:L))/max(abs(real(hfilt(1:L))) ),'r'), hold on, 



figure,
plot(ff,abs(Hn)), hold on, 
plot(ff,abs(Hbox1),'r')

figure,
ww=[0:pi/1000:pi]; H=freqz([Cv,Cv],1,ww);
Hn = H/max(abs(H));
h=ifft([H,conj(H(end:-1:1))]);
plot(real(h(1:L))/max(abs(real(h(1:L))) ),'k--'), hold on, 


Hfilt = H.*(ww<=2*pi*fmax1);
hfilt=ifft([Hfilt,conj(Hfilt(end:-1:1))]);
plot(Cv/max(abs(Cv))), hold on
plot(real(hfilt(1:L))/max(abs(real(hfilt(1:L))) ),'r'), hold on, 


Hfilt = H.*(ww<=2*pi*fmax2);
hfilt=ifft([Hfilt,conj(Hfilt(end:-1:1))]);
plot(real(hfilt(1:L))/max(abs(real(hfilt(1:L))) ),'m'), 

sfmax1 = sprintf('Freq > %.3f Hz filtered out',fmax1);
sfmax2 = sprintf('Freq > %.3f Hz filtered out',fmax2);
legend('Original Signal',sfmax1, sfmax2)
xlabel('Arclength \rightarrow')
ylabel('Normal deformation \rightarrow')
title(sprintf('Approximate cut-off freq, fmax = %.3f Hz, Hz=cycles/pixel',fmax1))

figure,
plot(ww/(2*pi), abs(Hn)), hold on
plot(ww/(2*pi),(ww<=2*pi*fmax1),'r')
plot(ww/(2*pi),(ww<=2*pi*fmax2),'m')
s1 = sprintf('Box-car filter with %.2f Hz cut-off',fmax1);
s2 = sprintf('Box-car filter with %.2f Hz cut-off',fmax2);
legend('Fourier tfm. of Original Signal', s1,s2);
title('Freq Domain of original signal and approx cut-off points')
xlabel('Spatial freq (Hz=cycles/pixel) \rightarrow')
ylabel('Magnitude of Fourier tfm. \rightarrow')


% figure
% Ctrans = state2(t).Ctrans; Ctrans2 = state2(t+1).Ctrans; 
% cent = mean(C,2);
% cent2 = mean(C2,2);
% Ct = C ;%- cent*ones(1,L) ;
% C2t = C2 ;%- cent2*ones(1,length(C2));
% plotcontour(Ct,'b')
% plotcontour(C2t,'r')
% plotcontour(Ct +Ctrans*ones(1,Mt) + (ones(2,1)*Cvel).*N,'g.')  




