
%gendata_2obj

t = 3;
C = state2(t-1).C;
C2 = state2(t).C;
knotloc_moved = state2(t).knotloc_moved;
Cvel_basis = state2(t).Cvel_basis;
K = length(state2(t).Cvel_basis)
Mt=length(C)
L = Mt;
learn = 1;
if (~learn)
    [C,Cvel,knotloc,knotindx,N,Cdot_basis]  = get_velocity(C,K,0,knotloc_moved,Cvel_basis,lset);
else
    [N,T,sgn,normdCdp] = get_normal(C,lset);
    Cnewhat = zeros(size(C));
    for ct = 1:Mt
        point = C(:,ct);
        [indx,Cnewhat(:,ct),mindist] = getclosest(point,C2);
    end
    Cvelhat = Cnewhat - C;
    [N2,TT,sgn2]=get_normal(Cnewhat);
    if (sgn*sgn2==-1)
        disp('C,Cnewhat clockwise or anticlockwise'), keyboard
    end
    if  (sgn==-1)      %(sgn==1)&(t>2): screwing up'
        N = -N;
    end
    CvelhatN = sum(N.*Cvelhat,1);
end
if (~learn)
    Cdef = Cvel;
else
    Cdef = CvelhatN;
end

[arclen] = get_arclength(C);
len = arclen(end);
L =  floor(len);
[Cdef_unif] = interp1(arclen/len, Cdef, [1:L]/L,'cubic','extrap');


Cv = Cdef_unif;       %Cvelt2{t}; %  %.*normdCdp;


Nf = 2048;
fmax1 =  K/(2*L);
fmax2 = 1.3*K/(2*L);

H = fft([Cv,Cv, Cv, Cv], Nf); Hn = H/max(abs(H));
h = ifft(H); ff = [0: (1/Nf): 1-1e-15];
plot(Cv/max(abs(Cv)),'b','LineWidth',1.5), hold on
%plot(real(h(1:L))/max(abs(real(h(1:L))) ),'k--'), hold on,

Hbox1 = ( (ff<=fmax1) | (ff>=(1-fmax1)) );
Hfilt1 = H.* Hbox1 ;
hfilt1=ifft(Hfilt1);
plot(real(hfilt1(1:L))/max(abs(real(hfilt1(1:L))) ),'r--','LineWidth',1), hold on,

Hbox2 = ( (ff<=fmax2) | (ff>=(1-fmax2)) );
Hfilt2 = H.* Hbox2 ;
hfilt2=ifft(Hfilt2);
plot(real(hfilt2(1:L))/max(abs(real(hfilt2(1:L))) ),'k-x','LineWidth',1), hold on,

sfmax1 = sprintf('Freq <=%.3f Hz (def*h_1)',fmax1);
sfmax2 = sprintf('Freq <=%.3f Hz (def*h_1)',fmax2);
legend('deformation "signal", def', sfmax1, sfmax2)
xlabel('arclength \rightarrow')
ylabel('deformation \rightarrow')
title(sprintf('Estimating approx. cut-off freq (Hz=cycles/pixel)'))

figure,
plot(ff(1:end/2),abs(Hn(1:end/2)),'b','LineWidth',1.2), hold on,
plot(ff(1:end/2),abs(Hbox1(1:end/2)),'r--','LineWidth',1),
plot(ff(1:end/2),abs(Hbox2(1:end/2)),'k-x','LineWidth',1),
s1 = sprintf('H_1: LPF with %.3f Hz cut-off',fmax1);
s2 = sprintf('H_2: LPF with %.3f Hz cut-off',fmax2);
legend('FT of deformation', s1,s2);
title('Fourier Transform (FT) of deformation & Low-pass filtering (LPF) with approx cut-off freq')
xlabel('Spatial freq (Hz=cycles/pixel) \rightarrow')
ylabel('FT Magnitude  \rightarrow')


figure
Ctrans = state2(t).Ctrans
cent = mean(C,2);
cent2 = mean(C2,2);
Ct = C; %- cent*ones(1,Mt) ;
C2t = C2; %- cent2*ones(1,length(C2));
plotcontour(Ct,'b',3)
plotcontour(C2t,'r--',3)
%plotcontour(Ct +Ctrans*ones(1,Mt) + (ones(2,1)*Cvel).*N,'g.')

Cfin = Ct + Ctrans*ones(1,Mt) + (ones(2,1)*Cdef).*N;
% + Ctrans is WRONG because using LSM we are only translating along the normal direction
%Cfin = Ct + (ones(2,1)*(Ctrans'*N)).*N + (ones(2,1)*Cvel).*N;
%Cfin = Ct  + (ones(2,1)*Cvel).*N;
for ii = 1: length(Ct)
    plotcontour([Ct(:,ii), Cfin(:,ii)],'g-',1)
end
%plotcontour(Cfin,'g')

legend('C_{n-1}','C_{n}','def')
title('Estimated deformation (def) b/w C_t & C_{t-1} as a function of C_{t-1}')

