%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%This code is to solve the Modified-CS-residual problem
%%%%min ||y_res-Ax||_2^2+gamma ||x_{T^c}||_1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear

randn('state',0)
rand('state',0)

load brainsequence 

N=size(brainimageseq(:,:,1));

seqlen=3;%sequence length


sigma=sqrt(1);  %variace of noise

    

 

gammaBPDN =1;         %gamma for BPDN
gammamodcsres =1;     %gamma for modified-cs-residual
thr_modcsres=100;     %threshold for modified-cs-residual to pick


%%%%generate n=0.5m sampling mask
%%%%We want to sample more in low frequency regions. genSampling gives more samples in central regions(low frequency regions for fftshifted 2D Fourier transform)
[pdf,val] = genPDF(N,2,0.5,2,0,0);  
[mask1,stat,NN] = genSampling(pdf,100,10);
mask1=fftshift(mask1);            
 
%%%%%generate n=0.19m sampling mask
%%%%%genSampling only can generate the required mask for n>=0.25m samples.
%%%%%for n<0.25m, we can multiply another mask whose distribution is only generated on
%%%%%the half central regions.
[pdf,val] = genPDF(N,2,0.25,2,0,0);
[mask2,stat,NN] = genSampling(pdf,100,10);
mask2=fftshift(mask2);
 
maskreduce=ones(N);            %for n<0.25m mask 

[pdf,val] = genPDF(N/2,2,0.6,2,0,0);   %Change the samples for maskreduce to reduce samples for mask2
[maskreduce(N(1)/4+1:N(1)/4*3,N(2)/4+1:N(2)/4*3),stat,NN] = genSampling(pdf,100,10);
maskreduce=fftshift(maskreduce);
mask2=mask2.*maskreduce;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%wavelet transform 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=2;
dwtmode('per'); 
Xtmp=eye(N);
W=zeros(N);
for p=1:N(1)
       [W(:,p),L2] = wavedec(Xtmp(:,p),L,'db4');
end

%generate wavelet transform operator
XFM = Wavelet(W);	


%generate Fourier sampling operator
FT1 = p2DFT(mask1, N, 1, 2);

FT2=  p2DFT(mask2, N, 1, 2);

%Obtain measurements
for seq=1:seqlen

       if seq==1
           FT=FT1;
           mask=mask1;
           
       else
           FT=FT2;
           mask=mask2;
       end
       
       
    
   y{seq}=FT*brainimageseq(:,:,seq)+(sigma*randn(N)).*mask;     %generate noisy measurements
   
   SNR(seq)=20*log10(norm(FT*brainimageseq(:,:,seq),'fro')/norm(y{seq}-FT*brainimageseq(:,:,seq),'fro'));   
  
end
   
    
 

%%%%%Do BPDN
xhat_BPDN=BPDNsequential(FT1,mask1,FT2,mask2,XFM,gammaBPDN,y);

%%%%%%Compute reconstruction error
   
for seq=1:seqlen
   
          error_BPDN(seq)=norm(xhat_BPDN(:,:,seq)-brainimageseq(:,:,seq),'fro')/norm(brainimageseq(:,:,seq),'fro') ; 
  
end



 
%%%%%%%Do Modified-CS-residual
xhat_modcsres=Modcsresidualsequential(FT1,mask1,FT2,mask2,XFM,gammaBPDN,y,thr_modcsres);

%%%%%%Compute reconstruction error

for seq=1:seqlen

          error_modcsres(seq)=norm(xhat_modcsres(:,:,seq)-brainimageseq(:,:,seq),'fro')/norm(brainimageseq(:,:,seq),'fro') ;
 
end

















