%%%%%%This function is to solve BPDN problem sequentially
%%%%%%xhat = min ||y - F* W' *x ||^2 + gamma*||x_{T^c}||_1


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%Parameters%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%FT1: partial Fourier operator for t=1
%%%%mask1: sampling mask for t=1
%%%%FT2: partial Fourier operator for t>1
%%%%mask2: sampling mask for t>1
%%%%XFM: wavelet transform operator
%%%%y: measurements
%%%%thr_modcsres: threshold for support estimation


function xhat = Modcsresidualsequential(FT1,mask1,FT2,mask2,XFM,gamma,y,thr_modcsres)

disp('Reconstruting using Modified-CS-Residual')

global masknz

for seq=1:length(y)
    
    
    
    if seq==1
   
        FT=FT1;
        
        mask=mask1;
        
        ytemp{seq}=y{1};
        
        disp('Reconstructing first frame using BPDN:')
        
        xhat_BPDN=BPDNsequential(FT1,mask1,FT2,mask2,XFM,gamma,ytemp);
        
        res0temp=XFM*xhat_BPDN;               
        
                 
    else

        FT=FT2;
        
        mask=mask2;
        
        res0temp=res_waveletmodcsres(:,:,seq-1);       
       
      end
   
    
  
     detectset=find(abs(res0temp)>thr_modcsres);        %known part of set T
     
     res0=zeros(size(mask1));  
     
     res0(detectset)=res0temp(detectset);           %Estimation on T
   
     masknz=ones(size(res0));
   
     masknz(detectset)=0;                           %masknz sets all indices in T to be 0, o.w. 1

     yres=y{seq}-FT*(XFM'*res0);                    %residual measurements
   
          param = init;
          param.FT = FT;
          param.XFM = XFM;
          param.data=yres;
          param.xfmWeight = gamma;
        
          res = XFM*(FT'*yres);                    %Initial guess of the residual signal
          
         
         %%%%Do Modified-CS-residual
         
          for n=1:5
            
            res = modcsres(res,param,masknz);            %Modified-CS-residual reconstruction

          end 
          
          res_waveletmodcsres(:,:,seq)=res0+res;  % reconstructed results=residual+estimation
          
          xhat(:,:,seq)=XFM'*res_waveletmodcsres(:,:,seq);  %reconstructed image
          
          
end
   