%%%%%%This function is to solve BPDN problem sequentially
%%%%%%xhat = min ||y - F* W' *x ||^2 + gamma*||x||_1


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%Parameters%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%FT1: partial Fourier operator for t=1
%%%%mask1: sampling mask for t=1
%%%%FT2: partial Fourier operator for t>1
%%%%mask2: sampling mask for t>1
%%%%XFM: wavelet transform operator
%%%%y: measurements


function xhat = BPDNsequential(FT1,mask1,FT2,mask2,XFM,gamma,y)

disp('Reconstructing using BPDN')

for seq=1:length(y)
    
    if seq==1
   
        FT=FT1;
        
        mask=mask1;
           
    else

        FT=FT2;
        
        mask=mask2;
       
    end
    
   
   %%%%%%%%%%%%%%%parameters definition%%%%%%%%%%%%%%%%%
   
          param = init;                 %Initial setting of all parameters
          param.FT = FT;                %Set partial Fourier transform operator
          param.XFM = XFM;              %Set wavelet transform operator  
          param.data=y{seq};         %measurements 
          param.xfmWeight = gamma;  %gamma for BPDN
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  

          res = XFM*(FT'*y{seq});    %initial estimation of original signal
          
                 
       
         
          for n=1:5
            
            res = BPDN(res,param);      %Do BPDN  

          end
         

          
          xhat(:,:,seq)=XFM'*res;  %reconstructed image
          
         
        
            
       

   end