%%%%%%%%%%%%%%%%%%%%%%%Simple-CS%%%%%%%%%%
function [xhat]=simplecs_sequential(A1,A2,y)           
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%A1 is the measurement matrix for first frame, A2 is the measurement
%%%%matrix for t>1 frames. y is the measured signal sequence
seqlen=length(y);   %length of sequence

m=size(A1,2);      %size of data


for seq=1:seqlen
    
    if seq==1
        
        A=A1;
        
    else 
        A=A2;
    end


%%%%Do CS:min ||x||_1,s.t. yt=Ax    
    cvx_begin
                  
        variable x(m); 
    
        minimize( norm(x,1) ) ;
    
        subject to
    
                A*x == y{seq};
           
    cvx_end 
    
    xhat(:,seq)=x;  %reconstructed sequence
    
end
            