%%%%%%%%%%%%%%This is a demo of cardiac sequence%%%%%
%%%%%The simulated sequence is sparse in wavelet domain and |Nt|=0.10m,|delta_t|<0.01m 
%%%%%Before running the code, you need to install cvx software
%%%%%http://www.stanford.edu/~boyd/cvx/
clear
randn('state',0)

load cardiacsequence

%%%%This stored cardiac data contain 1D reshaped wavelet coefficients and original 2D image domain data,
m=size(cardiacseq,1);         %size of each frame
N=[sqrt(m) sqrt(m)];

%%%%%generate wavelet transform matrix
L=2;                             %Decomposition level
dwtmode('per'); 
X=eye(N);
W=zeros(N);                      %wavelet transform matrix for 2D transform
for p=1:N(1)
       [W(:,p),L2] = wavedec(X(:,p),L,'db4'); % wavelet base is Daubecies 4
end

W1D=kron(W,W);   %1D transform wavelet matrix 


%%%%%%%%Generate Gaussian with wavelet measurement matrix%% 

A=randn(round(0.29*m),m);  %Gaussian matrix with n=0.5m measurements 
A = orth(A')'*W1D';                  %Measurement matrix=Gaussian+wavelet




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%For the sparsified cardiac sequence%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%generate measurements%%
y=A*sparsecardiacseq(:,1);

%%Run CS
xhatcs=simplecs_static(A,y);

%%%%%Compute rMSE
error_cs=norm(xhatcs-sparsecardiacseq(:,1))/norm(sparsecardiacseq(:,1));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%Run Modified-CS

T=[1:sqrt(m)/4 sqrt(m)+1:sqrt(m)+sqrt(m)/4  sqrt(m)*2+1:sqrt(m)*2+sqrt(m)/4 ...
    sqrt(m)*3+1:sqrt(m)*3+sqrt(m)/4 sqrt(m)*4+1:sqrt(m)*4+sqrt(m)/4 sqrt(m)*5+1:sqrt(m)*5+sqrt(m)/4 ...
    sqrt(m)*6+1:sqrt(m)*6+sqrt(m)/4 sqrt(m)*7+1:sqrt(m)*7+sqrt(m)/4];

xhatmodcs=Modifiedcs_static(A,y,T);

%%%%%Compute rMSE
error_modcs=norm(xhatmodcs-sparsecardiacseq(:,1))/norm(sparsecardiacseq(:,1));



% %%%%%%%%%%%%%%%%%%%%%%%%%generate measurements%%

ycomp=A*cardiacseq(:,1);
   

% 
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% %%Run CS
xhatcscomp=simplecs_static(A,ycomp);

%%%%%Compute rMSE
error_cscomp=norm(xhatcscomp-cardiacseq(:,1))/norm(cardiacseq(:,1));

% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%%Run Modified-CS

xhatmodcscomp=Modifiedcs_static(A,ycomp,T);

%%%%%Compute rMSE
error_modcscomp=norm(xhatmodcscomp-cardiacseq(:,1))/norm(cardiacseq(:,1));





