%%%%%%%%%%%%%%This is a demo of simulated sequence%%%%%
%%%%%The simulated sequence is sparse in wavelet domain and |N1|=0.0625m,
%%%%%|N10|=0.10m,|delta_t|<0.01m 
%%%%%Before running the code, you need to install cvx software
%%%%%http://www.stanford.edu/~boyd/cvx/
clear
randn('state',0)

load simseq

%%%%This stored data is 1D reshaped form of the origional 2D data,you can
%%%%reshape it to 2D form
m=size(simseqdata,1);         %size of each frame
seqlen=size(simseqdata,2);    %length of the sequence
N=[sqrt(m) sqrt(m)];

%%%%%generate wavelet transform matrix
L=2;                             %Decomposition level
dwtmode('per'); 
X=eye(N);
W=zeros(N);                      %wavelet transform matrix for 2D transform
for p=1:N(1)
       [W(:,p),L2] = wavedec(X(:,p),L,'db4'); % wavelet base is Daubecies 4
end

W1D=kron(W,W);   %1D transform wavelet matrix 


%%%%%%%%Generate Gaussian with wavelet measurement matrix%% 
% 
% A1=randn(round(0.5*m),m);  %Gaussian matrix with n=0.5m measurements for the first frame
% A1 = orth(A1')'*W1D';                  %Measurement matrix=Gaussian+wavelet
% 
% 
% A2=randn(round(0.16*m),m); %Gaussian matrix with n=0.16m measurements for the t>1 frames
% A2 = orth(A2')'*W1D';                 %Measurement matrix=Gaussian+wavelet



% %%%%%%%%%%%%%%%%%%%%%%%%%%%generate Fourier with wavelet measurement matrix%
% %generate Fourier matrix
Fu=dftmtx(sqrt(m));
FT=kron(Fu,Fu);

%generate complete Fourier with wavelet matrix
Aall=FT*inv(W1D)/sqrt(m);

%%%%generate n=0.5m sampling mask
%%%%We want to sample more in low frequency regions. genSampling gives more samples in central regions(low frequency regions for fftshifted 2D Fourier transform)
[pdf,val] = genPDF(N,2,0.5,2,0,0);  
[mask1,stat,NN] = genSampling(pdf,100,10);
mask1=fftshift(mask1);            
 
%%%%%generate n=0.16m sampling mask
%%%%%genSampling only can generate the required mask for n>=0.25m samples.
%%%%%for n<0.25m, we can multiply another mask whose distribution is only generated on
%%%%%the half central regions.
[pdf,val] = genPDF(N,2,0.25,2,0,0);
[mask2,stat,NN] = genSampling(pdf,100,10);
mask2=fftshift(mask2);
 
maskreduce=ones(N);            %for n<0.25m mask 

[pdf,val] = genPDF(N/2,2,0.3,2,0,0);   %Change the samples for maskreduce to reduce samples for mask2
[maskreduce(N(1)/4+1:N(1)/4*3,N(2)/4+1:N(2)/4*3),stat,NN] = genSampling(pdf,100,10);
maskreduce=fftshift(maskreduce);
mask2=mask2.*maskreduce;



%%%Find the sampling positions(1 in mask1 and mask2)
findnonz1=find(mask1==1);
 
findnonz2=find(mask2==1);
  
A1=Aall(findnonz1,:);   %generate Fourier with wavelet measurement matrix for first frame
A2=Aall(findnonz2,:);    %generate Fourier with wavelet measurement matrix for t>1 frames

%%%%%%%%%%%%%%%%%%%%%%%%%generate measurements%%
for seq=1:seqlen
    
    if seq==1
         y{seq}=A1*simseqdata(:,seq);
    else
         y{seq}=A2*simseqdata(:,seq);
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Run CS
xhatcs=simplecs_sequential(A1,A2,y);

%%%%%Compute rMSE
for seq=1:seqlen

    error_cs(seq)=norm(xhatcs(:,seq)-simseqdata(:,seq))/norm(simseqdata(:,seq));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%Run Modified-CS
thresholdmodcs=0.05;                         %Threshold for modified-CS to obtain support
xhatmodcs=Modifiedcs_sequential(A1,A2,y,thresholdmodcs);

%%%%%Compute rMSE
for seq=1:seqlen

    error_modcs(seq)=norm(xhatmodcs(:,seq)-simseqdata(:,seq))/norm(simseqdata(:,seq));
end







