function [t, df, n, d] = tstatistic(s1,s2)
%TSTATISTIC - computes student-t test statistic for paired t-test
%  [t,df] = tstatistic(s1,s2) computes test statistic comparing
%  columns of s1 to columns of s2.
%
%Ian Atkinson - 2005

%==========================================================================
%== Revision History ======================================================
%==========================================================================
% Date     | Author | Description 
%--------------------------------------------------------------------------
% 01.13.05 | IA     | Original write 
%--------------------------------------------------------------------------

    n1 = size(s1,1);
    n2 = size(s2,1);
    
    % calculate the degrees of freedom
    df = n1+n2-2;
    
    
    % the overall forumla for a pool-variance t-statistics is
    %
    %  t = mean(s1)-mean(s2)
    %      --------------------
    %       /----------------
    %     \/ Sp^2(1/n1 + 1/n2)
    %    
    % where Sp^2 = ((n1-1)*var(s1) + (n2-1)*var(s2))/df
    % 
    
    % calculate means
    us1 = mean(s1);
    us2 = mean(s2);
    
    pvar = ((n1-1)*var(double(s1)) + (n2-1)*var(double(s2)))/df;
    
    n = us1-us2;
    d = sqrt(pvar*(1/n1+1/n2));
    
    
    t = n./d;

