function  voxel=synthesizefMRIActivation(voxel)
%SYTHESIZEFMRIDATASET - create a synthetic datset from a source dataset by
%  resampling the timeseries using the wavestrapping method.
%
%Ian Atkinson - 2005


%==========================================================================
%== Revision History ======================================================
%==========================================================================
% Date     | Author | Description 
%--------------------------------------------------------------------------
% 09.13.05 | IA     | Original write 
%--------------------------------------------------------------------------
% 12.19.06 | IA     | Updated waitbar calls
%--------------------------------------------------------------------------

global fMRI_QUIET;

quiet = false;
if(fMRI_QUIET)
    quiet = true;
end

try
    err = 0;
    
    levels=4;
    
    % set all called fuctions to quiet
    fMRI_QUIET = true;
    
    BLK_SZ = 64;
    N = size(voxel,2);

    J = nextpow2(size(voxel,1)-1);
    
    idxd = [];
    for l=J-1:-1:J-levels
        idxsb{J-l} = subbandindexesn(l, 'H', 'origsize', size(voxel,1));    
        idxd = [idxd idxsb{J-l}];
    end
    
    for(k=1:BLK_SZ:N)
        blkidx = [k:min(k+BLK_SZ-1,size(voxel,2))];

        waitbar(k/N, 'Sythesizing fMRI Dataset', 'Name', 'synthesizefMRIDataset', 'DelayPeriod', 0, 'LingerPeriod', 2);

                
        % grab voxels to process in this block
        vox = double(voxel(:,blkidx));    
        
        trnd = vox;        
        %vox = detrendvoxels(vox, 1);
        trnd = trnd-vox;

        if (rem(log2(size(vox,1)),1)~=0)

            % x is not a power of 2 length vector
            sz = pow2(nextpow2(size(vox,1)));
            szc = size(vox,1);
            
            % mirror pad the data
            vox = [vox; vox(sz-szc:-1:1,:)];
            
            %vox = zpad(vox, [sz, size(vox,2)]);
        end

        [n,J] = dyadlength(vox(:,1));

        % take wavelet transform       
        vox = fwtc_po(vox, J-levels, MakeONFilter('Daubechies', 4));       
        
        idxs = [];
        
        for l=J-levels:J-1
            % get indexes for this subband
            idx = idxsb{J-l};
            
            % create all random permutations
            [dummy,perm] = sort(rand(length(idx),size(vox,2)));
            
            idxs = [idxs; perm];                                  
        end

        idxs = idxd(idxs) + repmat(0:size(vox,1):(prod(size(vox))-1), size(idxs,1), 1); 
        
        % permute the subbands
        vox(repmat(idxd(:), 1, size(idxs,2))+repmat(0:size(vox,1):(prod(size(vox))-1), size(idxs,1), 1)) = vox(idxs);

        % un-transform
        vox = iwtc_po(vox, J-levels, MakeONFilter('Daubechies', 4));        
        vox = vox(1:size(voxel,1),:);        
        
        % replace trend
        vox = vox + trnd;
        vox = max(vox,0);

        % store back
        eval(sprintf('voxel(:,blkidx) = %s(vox);', class(voxel)));
    end
catch
    err = 1;
end

waitbar(1);

% restore quiet state
fMRI_QUIET = quiet;
    
if(err)
    error(lasterr);
end
    
