clear all;


SCAN = '17086_2'; % file to add BOLD contrast to
CNR = 4; % average CNR of added BOLD signal

% load data
load([SCAN '.mat']);            % loads data into variable "data"
load([SCAN '_BOLDmask.mat']);   % loads data into variable "mask" (created from activation scan 16486)
load('BOLDshape.mat');          % shape of BOLD signal in variable BOLD (created using BOLDmodel and BOLDmodelParams)

% subsample original frames

BOLD = BOLD/max(BOLD(:));

    for m = 1:32
        for n = 1:32
            data_down(m,n,:,:) = squeeze(data(2*m,2*n,:,:));
        end
    end
    
     
H = fspecial('average',3);  %define average filter


for z=1:38
    for t = 1:90
        
        data_downno(:,:,z,t) = imfilter(data_down(:,:,z,t),H);
        
    end 
end

    
    
 % downsample mask
 
for m = 1:32
    for n = 1:32
        mask_down(m,n,:) = squeeze(mask(2*m,2*n,:));
    end
end

% Add BOLD

% compute noise in rest data
noise_std = std(abs(data_downno), 0, 4);

% compute average noise of voxels that will be made active
idxActiveVoxels = find(mask_down==1);
noise_std_ave = mean(noise_std(idxActiveVoxels));

% compute necessary signal amplitude to give desired SNR
req_contrast = CNR*noise_std_ave;

% add contrast
for k=1:size(data_downno,4)
   data_down(:,:,:,k) = data_downno(:,:,:,k) + mask_down*BOLD(k)*req_contrast;
end
 

% convert 4-D data to 3-D data 

seqlen=90;  %length of sequence

for seq = 1:seqlen
    
    data_3d(:,:,seq) = data_down(:,:,9,seq);
    
end 


for seq = 1:seqlen
    
    data_3dno(:,:,seq) = data_downno(:,:,9,seq);
    
end 


kSpace =fftshift(fft2(fftshift(data_3d)));


save data4cvx_cnr4
 
 


 
