%%%%%%This function is to solve BPDN problem sequentially
%%%%%%xhat = min ||y - F* W' *x ||^2 + gamma*||x_{T^c}||_1


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%Parameters%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%FT1: partial Fourier operator for t=1
%%%%mask1: sampling mask for t=1
%%%%FT2: partial Fourier operator for t>1
%%%%mask2: sampling mask for t>1
%%%%XFM: wavelet transform operator
%%%%y: measurements
%%%%thr_modcsres: threshold for support estimation


function [xhat,T_active,amap_seq] = modcsresCausalDetection(FT1,mask1,FT2,mask2,XFM,gamma,y,thr_modcsres,dataseq,dataseq1)

disp('Reconstruting using Modified-CS-Residual')

global masknz

for seq=1:length(y)
    
    
    
    if seq==1
   
        FT=FT1;
        
        mask=mask1;
        
        ytemp{seq}=y{1};
        
        disp('Reconstructing first frame using inverse DFT:')
        
        xhat_first = ifft2(y{seq}*64);
                
        wave_first=XFM*xhat_first;
        
        xhat(:,:,seq) = xhat_first;
        
        im_first = xhat_first;
    end
    
    
    
                 
    if seq >1

        FT=FT2;
        
        mask=mask2;
        
        res0temp=XFM*xhat(:,:,seq-1);       
  
        detectset=find(abs(res0temp)>thr_modcsres);        %known part of set T

       
        res0=zeros(size(mask1));  
     
        res0(detectset)=res0temp(detectset);     %Estimation on T
   
        masknz=ones(size(res0));
   
        masknz(detectset)=0;                     %masknz sets all indices in T to be 0, o.w. 1

        yres=y{seq}-FT*(XFM'*wave_first);        %residual measurements is obtained by substracting the accurate estimation of the first frame, because we are using fullsampling for the first frame
   
          param = init;
          param.FT = FT;
          param.XFM = XFM;
          param.data=yres;
          param.xfmWeight = gamma;
        
          res = XFM*(FT'*yres);                    %Initial guess of the residual signal
          
         
         %%%%Do Modified-CS-residual
         
          for n=1:5
            
            res = modcsres(res,param,masknz);            %Modified-CS-residual reconstruction

          end 
          
          res_waveletmodcsres(:,:,seq)=wave_first+res;  % reconstructed results=residual+estimation
          
          xhat(:,:,seq)=XFM'*res_waveletmodcsres(:,:,seq);  %reconstructed image
    
          
          
    %%%% Do Causal Detection for the first 30, 40, 50, 60, 70, 80,and 90 frames and save active pixel indexes    
          
    if seq ==10 || seq ==20 || seq==30 || seq ==40 || seq ==50 || seq==60 || seq ==70 ||seq==80 || seq ==90
           
        A = zeros(10,seq/10);
        A(:,[2:2:end])=1;
        A(:,[3:2:end])=-1;
        idxActive = find(A==1);
        idxRest   = find(A==-1);

        data = xhat;
    
        % make activation map
        background = mean(abs(data),3);
        sz = size(background);

        data = reshape(data, prod(sz), size(data,3)).';

        amap = activationmap(abs(data), 'ttest', sz, background, 'idxActive', idxActive, 'idxRest', idxRest, 'threshold.t', 2.5);
    
        T_active{seq} = find(amap.active ==1);
    
        amap_seq{seq} = amap;
        
        
        %%%%The code below can be used to do another modified-CS-residual
        %%%%on the support of detected active pixels each time.
    
%         masknz2=ones(size(masknz));
%         masknz2( T_active{seq})=0;                           %masknz sets all indices in T to be 0, o.w. 1
%      
%      
%         XFM2 = eye(size(XFM));
%         yres2=y{seq}-FT*(XFM2'*im_first);                    %residual measurements
%    
%           param2 = init;
%           param2.FT = FT;
%           param2.XFM = XFM2;
%           param2.data=yres2;
%           param2.xfmWeight = gamma;
%         
%           res = XFM2*(FT'*yres2);                    %Initial guess of the residual signal
%           
%          
%          %%%%Do Modified-CS-residual
%          
%           for n=1:5
%             
%             res = modcsres(res,param2,masknz2);            %Modified-CS-residual reconstruction
% 
%           end 
%           
%             xhat(:,:,seq)=im_first+XFM2'*res;  % reconstructed results=residual+estimation
%           
%             xhat(:,:,seq)=XFM'*res_waveletmodcsres(:,:,seq);  %reconstructed image        
%        end


    end
    error_modcsres1(seq)= norm(abs(xhat(:,:,seq))-abs(XFM'*dataseq(:,:,seq)),'fro')/norm(abs(XFM'*dataseq(:,:,seq)),'fro')
end
                  
end
   