function mn = minall(varargin)
%MINALL - finds the minimum entry of ALL arguments in ALL dimensions.
%  MINALL(A,B,C,...) will find the min elements of A,B,C,... and then
%  return the min of all of them.
%
%  Example:
%    A = [1 2 3; 4 5 6];
%    B = 4.56;
%    C = rand([3 3 6]);
%
%    mx = MINALL(A,B,C)
%
%  mx will be 6.
%
%  See Also: MAX, MIN, MAXALL
%
%Ian Atkinson - 2002

%==========================================================================
%== Revision History ======================================================
%==========================================================================
% Date     | Author | Description 
%--------------------------------------------------------------------------
% 09.14.04 | IA     | Improved speed/memory
%--------------------------------------------------------------------------

mn = inf;

for i=1:nargin
    arg = varargin{i};

    while(length(arg)>1)
        arg = min(arg);
    end
    
    mn = min([arg;mn]);   
end