function mx = maxall(varargin)
%MAXALL - finds the maximum entry of ALL arguments in ALL dimensions.
%  MAXALL(A,B,C,...) will find the max elements of A,B,C,... and then
%  return the max of all of them.
%
%  Example:
%    A = [1 2 3; 4 5 6];
%    B = 4.56;
%    C = rand([3 3 6]);
%
%    mx = MAXALL(A,B,C)
%
%  mx will be 6.
%
%  See Also: MAX, MIN, MINALL
%
%Ian Atkinson - 2002

%==========================================================================
%== Revision History ======================================================
%==========================================================================
% Date     | Author | Description 
%--------------------------------------------------------------------------
% 09.14.04 | IA     | Improved speed/memory
%--------------------------------------------------------------------------


mx = -inf;

for i=1:nargin
    arg = varargin{i};
     
    while(length(arg)>1)
        arg = max(arg); 
    end
    
    mx = max([arg;mx]);   
end