function x = iwtc_po(wc,L,qmf)
%IWTC_PO -  Inverse wavelet transform of columns (periodized,
%  overcomplete).  IWTC_PO(wc,L,qmf) will compute the inverse wavelet
%  transform of each column of wc. L  specifies the coarest level that was 
%  transformed down to using the orthonormal filter specified by the 
%  quadrature mirror filter (qmf).
%
%  See Also: MAKEONFILTER, FWTC_PO
%
%  Note: Requires WaveLab
%
%Ian Atkinson - 2005

%==========================================================================
%== Revision History ======================================================
%==========================================================================
% Date     | Author | Description 
%--------------------------------------------------------------------------
% 09.14.04 | IA     | Original write
%--------------------------------------------------------------------------



    x = wc(1:2^L,:);
	[n,J] = dyadlength(wc(:,1));
    
	for j=L:J-1
		x = up_dyad_lo(x,qmf) + up_dyad_hi(wc(dyad(j),:),qmf);
    end
 
    
function y = up_dyad_lo(x,qmf)
    y =  iconvr(qmf, up_sample(x).' ).';

function y = up_dyad_hi(x,qmf)
    y=up_sample(x);

    y = aconvr(MirrorFilt(qmf), y([end 1:end-1],:).').';

function y=up_sample(x)
    y = zeros(2*size(x,1), size(x,2));

    y(1:2:end,:) = x;
