function y = iconvr(f,x)
%ICONVR - Filtering by periodic convolution of x with f.  Exactly the same
%  as iconv except the the filtering is applied (efficiently) to each row.
%
%  See Also: ICONV, ACONV, ACONVR
%
%Ian Atkinson - 2002

% Note: Code based from wavelab's iconv

n = length(x(1,:));
p = length(f);
if p <= n,
    xpadded = [x(:,(n+1-p):n) x];
else
    z = zeros(1,p);
    for i=1:p,
        imod = 1 + rem(p*n -p + i-1,n);
        z(:,i) = x(:,imod);
    end
    xpadded = [z x];
end
ypadded = conv2(f,xpadded);
y = ypadded(:,(p+1):(n+p));


