function wc = fwtc_po(x,L,qmf)
%FWTC_PO -  Forward wavelet transform of columns (periodized,
%  overcomplete).  FWTC_PO(x,L,qmf) will compute the forward wavelet
%  transform of each column of x. L  specifies the coarest level to 
%  transform down to using the orthonormal filter specified by the 
%  quadrature mirror filter (qmf).
%
%  See Also: MAKEONFILTER, FWT_PO
%
%  Note: Requires WaveLab
%
%Ian Atkinson - 2005

%==========================================================================
%== Revision History ======================================================
%==========================================================================
% Date     | Author | Description 
%--------------------------------------------------------------------------
% 09.14.04 | IA     | Original write
%--------------------------------------------------------------------------


	[n,J] = dyadlength(x(:,1));
    
    wc = zeros(size(x));
    
	for j=J-1:-1:L,        
        wc(dyad(j),:) = down_dyad_hi(x,qmf);
        x = down_dyad_lo(x,qmf);        
    end   
    
    wc(1:2^L,:) = x;
 
    function d = down_dyad_lo(x,qmf)
        d = aconvr(qmf,x.').';
	    d = d(1:2:(end-1),:);
        
    function d = down_dyad_hi(x,qmf)
        d = iconvr(MirrorFilt(qmf),x([2:end,1],:).').';        
        d = d(1:2:(end-1),:);
            