addpath('WaveLab8.02/Orthogonal/'); % needed for wavestrapping resampling
clear;
randn('state',0)
rand('state',0)


SCAN = '17086_2'; % file to add BOLD contrast to
CNR = 4; % average CNR of added BOLD signal
NSIM = 10; % number of repeated simulations to uniquely resampled noise

for sim=1:NSIM
      
   
    clear y;
    % load data
    load([SCAN '.mat']);            % loads data into variable "data"
    load([SCAN '_BOLDmask.mat']);   % loads data into variable "mask" (created from activation scan 16486)
    load('BOLDshape.mat');          % shape of BOLD signal in variable BOLD (created using BOLDmodel and BOLDmodelParams)
    
    % make sure BOLD data has max of 1
    BOLD = BOLD/max(BOLD(:));
    
    sz = size(data);
    data = reshape(data, prod(sz(1:3)), sz(4)).';    % turn into columns for resampling
    data = synthesizefMRIDataset(data);              % resample to get "new" observation of noise based on seed dataset
    data = reshape(data.', sz);                      % back to 4-D
    
    % compute noise in rest data
    noise_std = std(abs(data), 0, 4);
    
    % compute average noise of voxels that will be made active
    idxActiveVoxels = find(mask==1);
    noise_std_ave = mean(noise_std(idxActiveVoxels));
    
    % compute necessary signal amplitude to give desired SNR
    req_contrast = CNR*noise_std_ave;
        
    
    % add contrast
    for k=1:size(data,4)
        data(:,:,:,k) = data(:,:,:,k) + mask*BOLD(k)*req_contrast;
    end
    
    % save result
    save([SCAN '_CNR=' num2str(CNR) '_' num2str(sim) '_of_' num2str(NSIM) '.mat'], 'data', 'time', 'mask', 'CNR', 'sim', 'NSIM');  
    
    orgdata=squeeze(data(:,:,9,:));
       activemask = mask(:,:,9);
    
   
    
    
    %%%%%%%Mod-CS-res reconstruction
    
    data_3d=squeeze(orgdata(1:end,1:end,1:end));



 

gammaBPDN=0.1;          %gamma for BPDN
gammamodcsres=0.05;     %gamma for modified-cs-residual
% thr_modcsres=400;       %threshold for modified-cs-residual to pick



N=[64 64];
N0=size(data_3d);
N=[N0(1) N0(2)];
[pdf,val] = genPDF(N,3,1,2,0,0);  
[mask1,stat,NN] = genSampling(pdf,100,10);
mask1=fftshift(mask1);            
 
%%%%%generate n=0.19m sampling mask
%%%%%genSampling only can generate the required mask for n>=0.25m samples.
%%%%%for n<0.25m, we can multiply another mask whose distribution is only generated on
%%%%%the half central regions.
% [pdf,val] = genPDF(N(1),3,0.5,2,0,0);
% [mask2r,stat,NN] = genSampling(pdf,100,10);

%  down=3;
%  mask2=Random_DownsamplingMASK(N(1),N(2),89,down);



 down=1;
 mask2=Random_DownsamplingMASK(N(1),N(2),89,down);










 
%  mask2r=fftshift(mask2r);
% 
%  
%   mask2=mask2r'*ones(1,N(1));  %2D mask



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%wavelet transform 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=2;
dwtmode('per'); 

Xtmp=eye(N);

W=zeros(N);
for p=1:N(1)
       [W(:,p),L2] = wavedec(Xtmp(:,p),L,'db4');
end

%generate wavelet transform operator
XFM = Wavelet(W);	


%generate Fourier sampling operator
FT1 = p2DFT(mask1, N, 1, 2);


for seq = 1:89

    
FT2(seq)=  p2DFT(mask2(:,:,seq), N, 1, 2);

end
seqlen=90;

%Obtain measurements
for seq=1:seqlen

       if seq==1
           FT=FT1;
           samplingmask=mask1;
           
       else
           %
           
           FT=FT2(seq-1);
           samplingmask=mask2(:,:,seq-1);
       
       end
       
       
    
   y{seq}=FT*data_3d(:,:,seq);     %generate noisy measurements

  
end
 



 
for seq=1:seqlen

       % dataseq(:,seq)=reshape(W*data_3d(1:end,1:end,seq)*W',m,1);%wavelet coefficients
                                  
        dataseq(:,:,seq)=W*data_3d(1:end,1:end,seq)*W';
        dataseq1(:,seq)=reshape(W*data_3d(1:end,1:end,seq)*W',prod(N),1);
end


for seq = 1:seqlen
    xhat_fullsample(:,:,seq) = ifft2(y{seq}*64);
    error_fullsample(seq)=norm(abs(xhat_fullsample(:,:,seq))-abs(XFM'*dataseq(:,:,seq)),'fro')/norm(abs(XFM'*dataseq(:,:,seq)),'fro')
end


     save (['slice9_fullsample_CNR=' num2str(CNR) '_' num2str(sim)], 'xhat_fullsample','error_fullsample','activemask' ) 
end
