function v = field_default(params, field, default)
%FIELD_DEFAULT - returns default value if field doesn not exist and current
%  field value if is does.  FIELD_DEFAULT(p,field,default) will return
%  p.field if it exists or default if it does not.  If default is not
%  specified, the field will be assumed to be required and an error will be
%  generated if it does not.
%
%  Example:
%
%    a.b = 1;
%    c=field_default(a,'b',10); 
%    d=field_default(a,'c.d',100);
%    d=field_default(a,'k'); % generates error
%
%    c will be 1 and d will be 100
%
%Ian Atkinson - 2005

%==========================================================================
%== Revision History ======================================================
%==========================================================================
% Date     | Author | Description 
%--------------------------------------------------------------------------
% 01.14.05 | IA     | Original write 
%--------------------------------------------------------------------------
% 04.02.05 | IA     | Made default optional and throw error when not
%          |        | specified and param.field does not exist
%--------------------------------------------------------------------------

   
    i = find(field=='.');
    
    if(isempty(i))
        fld = field;
        field = [];
    else
        fld = field(1:i-1);
        field = field(i+1:end);
    end
    
    if(isfield(params, fld))
        if(isempty(field))
            v = getfield(params, fld);
        else
            if(exist('default', 'var'))
                v = field_default(getfield(params, fld), field, default);
            else
                v = field_default(getfield(params, fld), field);
            end
        end
    else
        if(exist('default', 'var'))        
            v = default;
        else
            error(sprintf('Value for %s required', fld));
        end
    end