%%%%%%This function is to solve BPDN problem sequentially
%%%%%%xhat = min ||y - F* W' *x ||^2 + gamma*||x||_1


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%Parameters%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%FT1: partial Fourier operator for t=1
%%%%mask1: sampling mask for t=1
%%%%FT2: partial Fourier operator for t>1
%%%%mask2: sampling mask for t>1
%%%%XFM: wavelet transform operator
%%%%y: measurements


function [xhat] = csresidualsequential(FT1,mask1,FT2,mask2,XFM,gamma,y,thr_modcsres,dataseq,dataseq1)

disp('Reconstructing using csdiff')

for seq=1:90
    
  if seq ==1
   
        FT=FT1;
        
        mask=mask1;
           
      
        
        ytemp{1}=y{1};
        
        disp('Reconstructing first frame using inverse DFT:')
        
        xhat_first = ifft2(y{seq}*64);
        
        
        wave_first=XFM*xhat_first;
        

        xhat(:,:,seq) = xhat_first;
        
        im_first = xhat_first;
        
        

                

  else

        FT=FT2;
        
        mask= mask2;
        
        res0temp=XFM*xhat(:,:,seq-1);       
                     
        yres=y{seq}-FT*(XFM'*wave_first);    % Residual measurement is obtained by substracting  the accurate estimation of the first frame
        
     
  
    
   
   %%%%%%%%%%%%%%%parameters definition%%%%%%%%%%%%%%%%%
   
          param = init;                 %Initial setting of all parameters
          param.FT = FT;                %Set partial Fourier transform operator
          param.XFM = XFM;              %Set wavelet transform operator  
          param.data= yres;             %measurements 
          param.xfmWeight = gamma;      %gamma for BPDN
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  

          res = XFM*(FT'*yres);    %initial estimation of original signal
          
                 
       
         
          for n=1:5
            
            res = BPDN(res,param);      %Do BPDN  

          end
          
          
          res_waveletmodcsres(:,:,seq)=wave_first+res;  % reconstructed results=residual+estimation
          
          xhat(:,:,seq)=XFM'*res_waveletmodcsres(:,:,seq);  %reconstructed image    
          
     
          
          
  end
          error_csresidual1(seq)=norm(abs(xhat(:,:,seq))-abs(XFM'*dataseq(:,:,seq)),'fro')/norm(abs(XFM'*dataseq(:,:,seq)),'fro')
       

         
        
            
       

end