%%%%%%This function is to solve BPDN problem sequentially
%%%%%%xhat = min ||y - F* W' *x ||^2 + gamma*||x||_1


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%Parameters%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%FT1: partial Fourier operator for t=1
%%%%mask1: sampling mask for t=1
%%%%FT2: partial Fourier operator for t>1
%%%%mask2: sampling mask for t>1
%%%%XFM: wavelet transform operator
%%%%y: measurements


function xhat = csdiffsequential(FT1,mask1,FT2,mask2,XFM,gamma,y,dataseq)

disp('Reconstructing using CS-diff')

for seq=1:length(y)
    
  
   if seq ==1
       
        FT=FT1;
        
        mask=mask1;   

        ytemp{1}=y{1};
        
        disp('Reconstructing first frame using inverse DFT:')
        
        xhat_first = ifft2(y{seq}*64);
        
        xhat(:,:,seq) = xhat_first;
       
  

   else
       
       FT = FT2;
       
       mask = mask2;

       
       if seq ==2
           
        yres = y{seq}-(FT*xhat(:,:,seq-1)); 
        
       else
           
        yres = y{seq}-y{seq-1};
           
       end
       
      prevtemp = xhat(:,:,seq-1);
  
    
   
   %%%%%%%%%%%%%%%parameters definition%%%%%%%%%%%%%%%%%
   
          param = init;                 %Initial setting of all parameters
          param.FT = FT;                %Set partial Fourier transform operator
          param.XFM = XFM;              %Set wavelet transform operator  
          param.data= yres;         %measurements 
          param.xfmWeight = gamma;  %gamma for BPDN
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  

          res = XFM*(FT'*yres);    %initial estimation of original signal
          
                 
       
         
          for n=1:5
            
            res = BPDN(res,param);      %Do BPDN  

          end
          
          
          
          
          
          xhat(:,:,seq)=XFM'*res + prevtemp ;  %reconstructed image
          
          
   end

                      error_csdiff1(seq)=norm((xhat(:,:,seq))-(XFM'*dataseq(:,:,seq)),'fro')/norm((XFM'*dataseq(:,:,seq)),'fro')
       
end
         
        
            
       

end