function [pd, pf, md, ms,tau_seq] = computefMRIROC(amap, Pf, trueActivation, type)
%COMPUTEFRMIROC - compute ROC curve for an activation map
%  [Pd, Pf, md, ms] = COMPUTEFMRIROC(amap, Pf, trueActivation) will compute 
%  the receiver operating characteristic (ROC) curve for the activation map
%  amap.  Values will be computed for the probability of false alarm
%  specified by Pf.  Locations of true activation must be indicated with
%  the parameter trueActivation (binary mask).  The output parameters md
%  and ms are the mean distance (from the closest true activation) and
%  separation of false positive voxels, respectively.
%
%  See Also: ACTIVATIONMAP, DISPLAYACTIVATIONMAP
%   
%Ian Atkinson - 2006

%==========================================================================
%== Revision History ======================================================
%==========================================================================
% Date     | Author | Description 
%--------------------------------------------------------------------------
% 05.22.06 | IA     | Original write
%--------------------------------------------------------------------------

if(nargin<4) type = 'normal'; end

sz = size(trueActivation);

% first pull out tvalues for all data
data = reshape([amap.tvalue], sz);


% get active and inactive indexes
idxActive = find(trueActivation==1);
idxInactive = find(trueActivation==0);


Na = length(idxActive);
Nna = length(idxInactive);


% get sub-script indexes of each value
[iy,ix,iz] = ind2sub(sz, 1:prod(sz));
iy = iy(:);
ix = ix(:);
iz = iz(:);
da = zeros(Nna,1);

for(k=1:Nna)
    % compute the distance to the closest active voxel
    d = repmat([iy(idxInactive(k)) ix(idxInactive(k)) iz(idxInactive(k))], Na, 1)-[iy(idxActive) ix(idxActive) iz(idxActive)];
    d = sqrt(sum(abs(d).^2, 2)).^2;
    da(k) = min(d);    
end

allDistances = unique(da);

% compute weighting values
switch(type)
    case 'normal'
        W = ones(Nna,1);
        
    otherwise

        % compute weighting values for inactive voxels that are falsely
        % active
        eval(['W=' eval((['sprintf(''' type ''', ''da'');'])) ';']);
end

% force the total weight to be Nna
W = Nna*W./sum(W);


% get just the non-active data (sorted)
[snaData, sIdx] = sort(data(idxInactive));
snaData = snaData(end:-1:1);
sIdx = sIdx(end:-1:1);

% apply same sorting rule to weights
ASW = cumsum(W(sIdx));

pd = zeros(size(Pf(:)));
pf = zeros(size(Pf(:)));
md = zeros(size(Pf(:)));
ms = zeros(size(Pf(:)));
        
for(pfIdx = 1:length(Pf))                

    tIdx = find(ASW>Pf(pfIdx)*Nna, 1, 'first');
    tIdx = max([tIdx 1]);
    
    tau = snaData(tIdx);
       tau_seq(pfIdx) = tau;    
    pd(pfIdx) = sum(data(idxActive)>=tau)/length(idxActive);
    pf(pfIdx) = sum((data(idxInactive)>=tau).*W)/length(idxInactive);
    
    
    if(nargout>2)
        idxFp = find(data(idxInactive)>=tau);

        % get the distances
        dis = da(idxFp);
        cnt = zeros(length(idxFp),1);
        for(k=1:length(dis))
            cnt(k) = sum(da==dis(k));
        end

        md(pfIdx) = sum(dis)/length(idxFp);
    end
    
    if(nargout>3)
        for(k=1:length(idxFp))
            idx = idxFp([1:k-1 k+1:end]);
            % compute the distance to the closest active voxel
            d = repmat([iy(idxFp(k)) ix(idxFp(k)) iz(idxFp(k))], length(idx), 1)-[iy(idx) ix(idx) iz(idx)];
            d = sqrt(sum(abs(d).^2, 2)).^2;
            if(length(d)>0)
                dfp(k) = min(d);
            else
                dfp(k) = 0;
            end
        end
       
        ms(pfIdx) = sum(dfp)/length(dfp);
    end

end

