clear
RESULT = 'recondata_CNR = 4_slice9_1';
% load activemask
% script assumes that data samples are stored in RESULT.mat

load([RESULT '.mat']);

% build active and rest indexes
A = zeros(10,9);
A(:,[2:2:end])=1;
A(:,[3:2:end])=-1;
idxActive = find(A==1);
idxRest   = find(A==-1);

% data is defined as the reconstructon of each method
data=xhat_modcsres;
% make activation map
background = mean(abs(data),3);
sz = size(background);

data = reshape(data, prod(sz), size(data,3)).';



amap = activationmap(abs(data), 'ttest', sz, background, 'idxActive', idxActive, 'idxRest', idxRest, 'threshold.t',         2.1566);



% Compute and display the true positive rate and the false positive rate 

org_set = find(activemask==1); 

recon_set_modcsres = find(amap.active==1);

truedect_modcsres = intersect(recon_set_modcsres,org_set);         %%proportion of correctly detected activations to all added activation

frac_truemodcsres1 = size(truedect_modcsres,1)/size(org_set,1) 

falsedect_modcsres = setdiff(recon_set_modcsres,org_set);    

frac_falsemodcsres1 = size(falsedect_modcsres,1)/(4096-size(org_set,1)) 
figure;

% display the map
dispactivationmap(amap, 'pvalue', 'logOverlay', true); colorbar

