addpath('WaveLab8.02/Orthogonal/'); % needed for wavestrapping resampling
clear;
randn('state',0)
rand('state',0)


SCAN = '17086_2'; % file to add BOLD contrast to
CNR = 4; % average CNR of added BOLD signal
NSIM = 10; % number of repeated simulations to uniquely resampled noise

for sim=1:NSIM
    
    % load data
    load([SCAN '.mat']);            % loads data into variable "data"
    load([SCAN '_BOLDmask.mat']);   % loads data into variable "mask" (created from activation scan 16486)
    load('BOLDshape.mat');          % shape of BOLD signal in variable BOLD (created using BOLDmodel and BOLDmodelParams)
    
    % make sure BOLD data has max of 1
    BOLD = BOLD/max(BOLD(:));
    
    sz = size(data);
    data = reshape(data, prod(sz(1:3)), sz(4)).';    % turn into columns for resampling
    data = synthesizefMRIDataset(data);              % resample to get "new" observation of noise based on seed dataset
    data = reshape(data.', sz);                      % back to 4-D
    
    % compute noise in rest data
    noise_std = std(abs(data), 0, 4);
    
    % compute average noise of voxels that will be made active
    idxActiveVoxels = find(mask==1);
    noise_std_ave = mean(noise_std(idxActiveVoxels));
    
    % compute necessary signal amplitude to give desired SNR
    req_contrast = CNR*noise_std_ave;
        
    
    % add contrast
    for k=1:size(data,4)
        data(:,:,:,k) = data(:,:,:,k) + mask*BOLD(k)*req_contrast;
    end
    
    % save result
    save([SCAN '_CNR=' num2str(CNR) '_' num2str(sim) '_of_' num2str(NSIM) '.mat'], 'data', 'time', 'mask', 'CNR', 'sim', 'NSIM');  
    
    orgdata=squeeze(data(:,:,9,:));
% save result
%save([SCAN '_CNR=' num2str(CNR) '.mat'], 'data', 'time', 'mask', 'CNR');
     save (['genbrainactivecnr=' num2str(CNR) '_' num2str(sim)], 'orgdata', 'mask', 'BOLD', 'CNR')
end