function y = aconvr(f,x)
%ACONVR - Filtering by periodic convolution of x with time-reverse of f.  
%  Exactly the same as aconv except the the filtering is applied 
%  (efficiently) to each row.
%
%  See Also: ICONV, ACONV, ACONVR
%
%Ian Atkinson - 2002

% Note: Code based from wavelab's aconv

n = length(x(1,:));
p = length(f);
if p < n,
    xpadded = [x x(:,1:p)];
else
    z = zeros(size(x,1),p);
    for i=1:p,
        imod = 1 + rem(i-1,n);
        z(:,i) = x(:,imod);
    end
    xpadded = [x z];
end
fflip = reverse(f);
ypadded = conv2(fflip,xpadded);
y = ypadded(:,p:(n+p-1));
