function updateplots
global fig_list Update fig_update back_color
global allfig fig1 fig2 fig3 fig4 upd_never upd_ever

% This will allow the user (hopefully) to update the plots as each
% signal is generated, recommended by Steve Marron

% This will put a pop-up menu on the screen,
% allowing the user to choose what figures he wishes to update

% Creating the frame for updating of figures

if fig_update == [],
fig_update = figure;
set(fig_update,'Name','Figure Updates', ...
'units','normal','position',[0.1,0.2,0.35,0.3],...
'Color',back_color);

txt_options = uicontrol(gcf,'Style','Text',...
'Back',back_color,'Fore',[0 0 0],...
'units','normal','Position',[0.6,0.8,0.35,0.1],...
'String','Check Options');

allfig = uicontrol(gcf,'Style','checkbox',...
'units','normal','Position',[0.6,0.7,0.35,0.1],...
'Back',back_color,'Fore',[1 0 0],'value',0,... 
'String','All Figures','call','fig_list = [ 1 1 1 1];');

fig1 = uicontrol(gcf,'Style','checkbox',...
'units','normal','Position',[0.6,0.6,0.35,0.1],...
'Back',back_color,'Fore',[1 0 0],'value',0,...
'String','Figure 1','call','fig_list(1) = 1;');

fig2 = uicontrol(gcf,'Style','checkbox',...
'units','normal','Position',[0.6,0.5,0.35,0.1],...
'Back',back_color,'Fore',[1 0 0],'value',0,... 
'String','Figure 2','call','fig_list(2) = 1;');

fig3 = uicontrol(gcf,'Style','checkbox',...
'units','normal','Position',[0.6,0.4,0.35,0.1],...
'Back',back_color,'Fore',[1 0 0],'value',0,... 
'String','Figure 3','call','fig_list(3) = 1;');

fig4 = uicontrol(gcf,'Style','checkbox',...
'units','normal','Position',[0.6,0.3,0.35,0.1],...
'Back',back_color,'Fore',[1 0 0],'value',0,... 
'String','Figure 4','call','fig_list(4) = 1;');

txt_upd = uicontrol(gcf,'Style','Text',...
'Back',back_color,'Fore',[0 0 0],...
'units','normal','Position',[0.02,0.75,0.54,0.15],...
'String','Select Update Options'); 

upd_never = uicontrol(gcf,'Style','radio',...
'Back',back_color,'Fore',[1 0 0],'value',0,...
'units','normal','Position',[0.02,0.6,0.54,0.15],...
'String','Do not show this window again',...
'call','reset_updates1');
if get(upd_never,'Value') == 1,
  Update = 'Never';
else 
  Update = 'ever';
end;
upd_ever = uicontrol(gcf,'Style','radio',...
'Back',back_color,'Fore',[1 0 0],'value',1,...
'units','normal','Position',[0.02,0.45,0.54,0.15],...
'String','Show this window each time',...
'call','reset_updates2');


ft_upd = uicontrol(gcf,'Style','push', ...
'String','Update Figure(s)', ...
'units','normal','Position',[0.03,0.1,0.32,0.1], ...
'Back',back_color,'Fore',[1 0 0], ...
'CallBack','Update_figs');

ft_clear = uicontrol(gcf,'Style','push', ...
'String','Clear Selection', ...
'units','normal','Position',[0.35,0.1,0.3,0.1], ...
'Back',back_color,'Fore',[1 0 0], ...
'CallBack','clear_updates');

ft_close = uicontrol(gcf,'Style','push', ...
'String','Dismiss window','value',0, ... 
'units','normal','Position',[0.65,0.1,0.32,0.1], ...
'Back',back_color,'Fore',[1 0 0], ...
'CallBack','close_updates');

end;
    
    
%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
