% RiskBrowser.m
disp('********************************************************************')
disp('*   Exact Risk Analysis in Wavelet Regression                      *');
disp('********************************************************************')
clear;close all;risk_global;
%RiskBrowserIntro

com = computer;
if strcmp(com,'MAC2'),
  special_character = setstr(165);

elseif strcmp(com,'DEC_RISC')
  special_character = '*';

elseif strcmp(com,'SUN4');
  special_character = setstr(164);

end
back_color = [0.5 0.5 0.5];
global back_color
num_menus = 5;
  menu_names = [ ...
    'Data______'; ...
    'Signals___'; ...
    'Settings__'; ...
    'Actions___'; ...
    'Plots_____'; ...
               ];

% To add menu items, increase the appropriate number in the array
% below, and add the corresponding 'entries' and 'call backs':

num_menu_items = [ 1 10 0 5 0];

% -- Data for Data menu # 1 --- %

Data_______entries = [ ...
         'User Defined' ; ...
                     ];

Data_______callbacks = [ ...
         'Gen_data( 0 );' ; ...
                       ];

% -- Data for Signals menu #2 --- %

Signals____entries = [ ...
         'Step             ' ; ... 
         'Wave             ' ; ...
         'Blip             ' ; ...
         'Blocks           ' ; ...
         'Bumps            ' ; ...
         'HeaviSine        ' ; ...
         'Doppler          ' ; ...
         'Angles           ' ; ...
         'Parabolas        ' ; ...
         'Time Shifted Sine' ; ...
                   ];

Signals____callbacks = [ ...
  'Gen_signal( 1);' ; ...
  'Gen_signal( 2);' ; ...
  'Gen_signal( 3);' ; ...
  'Gen_signal( 4);' ; ...
  'Gen_signal( 5);' ; ...
  'Gen_signal( 6);' ; ...
  'Gen_signal( 7);' ; ...
  'Gen_signal( 8);' ; ...
  'Gen_signal( 9);' ; ...
  'Gen_signal(10);' ; ...
                    ];

% -- Data for Settings menu #3 --- %

Settings___entries = [ ...
           'Signal Length     ' ; ...
           'Noise Type        ' ; ...
           'Noise Level       ' ; ...
           'Wavelet           ' ; ...
           'Threshold selector' ; ...
           'Plot options      ' ; ...
                    ];

Settings___callbacks = [ ...
  'define_ ( 1 );'; ...
  'define_ ( 2 );'; ...
  'define_ ( 3 );'; ...
  'define_ ( 4 );'; ...
  'define_ ( 5 );'; ...
  'define_ ( 6 );'; ...
                   ];

% -- Data for Actions menu #3 --- %

Actions____entries = [ ...
           'Add Noise             ' ; ...
           'Fourier Transform     ' ; ...
           'Wavelet Transform     ' ; ...
           'DeNoise/Compress      ' ; ...
           'Quit                  ' ; ...
                     ];

Actions____callbacks = [ ... 
        'take_action(1) '; ...
        'take_action(2) '; ...
        'take_action(3) '; ...
        'take_action(4) '; ...
        'take_action(5) '; ...
                       ];

Plots______entries = [ ...
         'Wavelet and Fourier Transforms' ; ...
         'Power Remaining               ' ; ...
         'Exact Risk Plots              ' ; ...
                     ];

Plots______callbacks = [ ...
        'make_plot(1) '; ...
        'make_plot(2) '; ...
        'make_plot(3) '; ...
                    ];

% Creating the menus 

for ii = 1:num_menus
  menu_name = menu_names( ii, : );
  menu_tag = menu_name;
  menu_tags( ii, : ) = [ '*' menu_tag ];

  while menu_tag(length(menu_tag)) == '_'
    menu_tag(length(menu_tag)) = [];
  end
  menu_id = uimenu('Label', [ '*' menu_tag '    ' ], ...
                   'BackgroundColor',back_color,...
                   'ForegroundColor',[1 0 0 ] );
  menu_ids( ii ) = menu_id;
  if num_menu_items(ii) > 0,
          for kk = 1:num_menu_items( ii )
                st = [ 'menu_label = ' menu_name '_entries( kk, : );' ];
              eval( st )
                st = [ 'callback = ' menu_name '_callbacks( kk, : );' ];
              eval( st );

                uimenu( menu_id, ...
                'Label', menu_label, ...
                'BackgroundColor',back_color,...
                'ForegroundColor',[0 0 1], ...
                'CallBack', callback, ...
                'Separator','on' ...
                          );
          end
  end
end


%      Put in the other submenus now
%      Settings menu

       h_set = menu_ids(3);
       h_len = uimenu(h_set,'Label','Signal Length', ...
                'BackgroundColor',back_color,...
                'ForegroundColor',[0 0 1]);
       h_nty = uimenu(h_set,'Label','Noise Type', ... 
                'BackgroundColor',back_color,...
                'ForegroundColor',[0 0 1],'Separator','on');
       h_nlv = uimenu(h_set,'Label','Noise Level', ...
                'BackgroundColor',back_color,...
                'ForegroundColor',[0 0 1],'Separator','on');
       h_wav = uimenu(h_set,'Label','Wavelet', ...
                'BackgroundColor',back_color,...
                'ForegroundColor',[0 0 1],'Separator','on');
       h_thr = uimenu(h_set,'Label','Threshold Selector', ...
                'BackgroundColor',back_color,...
                'ForegroundColor',[0 0 1],'Separator','on');
       h_plot = uimenu(h_set,'Label','Plot Options', ...
                'BackgroundColor',back_color,...
                'ForegroundColor',[0 0 1],'Separator','on');

               
%	Settings submenus 
%
%       Signal length submenu
%

        global h_lenmenu
        h_lenmenu = zeros(6,1);
        h_lenmenu(1) = uimenu(h_len,'Label','64',...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'off', 'CallBack', 'use_siglen(  64);');
        h_lenmenu(2) = uimenu(h_len,'Label','128',...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'off', 'CallBack', 'use_siglen( 128);');
        h_lenmenu(3) = uimenu(h_len,'Label','256',...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'on', 'CallBack', 'use_siglen( 256);');
        h_lenmenu(4) = uimenu(h_len,'Label','512',...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'off', 'CallBack','use_siglen( 512);');
        h_lenmenu(5) = uimenu(h_len,'Label','1024',...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'off', 'CallBack','use_siglen(1024);');
        h_lenmenu(6) = uimenu(h_len,'Label','User Given',...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'off', 'CallBack','use_siglen(2048);');

%
%  Noise Type Submenu
%
        global h_ntymenu 
        h_ntymenu = zeros(4,1); 
        h_ntymenu(1) = uimenu( h_nty,'Label', 'Gaussian', ...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'on', 'CallBack', 'use_ntypes(1);');
        h_ntymenu(2) = uimenu( h_nty,'Label', 'Uniform', ...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'off', 'CallBack', 'use_ntypes(2);');
        h_ntymenu(3) = uimenu( h_nty,'Label', 'Poisson', ...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'off', 'CallBack', 'use_ntypes(3);');
        h_ntymenu(4) = uimenu( h_nty,'Label', 'User Given', ...
                     'BackgroundColor',back_color,...
                     'ForegroundColor',[0 1 0], ...
                     'Checked', 'off', 'CallBack', 'use_ntypes(4);');


%
%  Noise Level Submenu
%
        global h_nlvmenu
        h_nlvmenu = zeros(3,1);
        h_nlvmenu(1) = uimenu( h_nlv, 'Label', 'Low Noise, sigma = 0.02', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                       'Checked', 'on', 'CallBack', 'use_nlevel(1);');
        h_nlvmenu(2) = uimenu( h_nlv, 'Label', 'High Noise, sigma = 0.1', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                       'Checked', 'off' , 'CallBack', 'use_nlevel(2);');
        h_nlvmenu(3) = uimenu( h_nlv, 'Label', 'Custom Noise', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                       'Checked', 'off', 'CallBack', 'use_nlevel(3);');

%
%  Wavelet Type Submenu
%

        global h_wavmenu
        h_wavmenu = zeros(4,1);
        h_wavmenu(1) = uimenu( h_wav, 'Label', 'Haar', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'on', 'CallBack', 'use_wavelet(1);');
        h_wavmenu(2) = uimenu( h_wav, 'Label', 'Daubechies 6', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'off', 'CallBack', 'use_wavelet(2);');
        h_wavmenu(3) = uimenu( h_wav, 'Label', 'Symmlet 8', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'off', 'CallBack', 'use_wavelet(3);');
        h_wavmenu(4) = uimenu( h_wav, 'Label', 'Coiflet 3', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'off', 'CallBack', 'use_wavelet(4);');


%
% Threshold Selector submenu
%
        global h_thrmenu
        h_thrmenu = zeros(3,1);
        h_thrmenu(1) = uimenu( h_thr, 'Label', 'Hard Thresholding with R2Ln', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'on', 'CallBack', 'use_threshold(1);');
        h_thrmenu(2) = uimenu( h_thr, 'Label', 'Soft Thresholding with R2Ln', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'off', 'CallBack', 'use_threshold(2);');
        h_thrmenu(3) = uimenu( h_thr, 'Label', 'Soft Thresholding with DJMO', ...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'off', 'CallBack', 'use_threshold(3);');

%
% Plot options submenu
%
        global h_plotmenu
        h_plotmenu = zeros(3,1);
        h_plotmenu(1) = uimenu( h_plot,'Label', 'Signal in Use only',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'on', 'CallBack', 'use_pltoption(1);');
        h_plotmenu(2) = uimenu( h_plot,'Label',... 
                 'All signals in Browser',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'off', 'CallBack', 'use_pltoption(2);');
        h_plotmenu(3) = uimenu( h_plot,'Label',... 
                 'Choose signals from Browser',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0], ...
                 'Checked', 'off', 'CallBack', 'use_pltoption(3);');

%   Plots submenus
%   
%   Coefficients plots submenus
%
        h_plots = menu_ids(5);
        h_signal = uimenu(h_plots,'Label',...
                 'Plots of Signals: Fig. 1',...
                 'Checked','on',... 
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 0 1],'CallBack','make_plot(0);');
        h_coeff = uimenu(h_plots,'Label',...
                 'Wavelet and Fourier Transforms: Fig. 2',...
                 'Checked','off','Separator','on',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 0 1],'CallBack','make_plot(1);');
        h_power = uimenu(h_plots,'Label',...
                 'Power Remaining',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 0 1],'Separator','on');
        h_risk  = uimenu(h_plots,'Label','Exact Risk Plots',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 0 1],'Separator','on');

% Pwer plots submenus

        global h_powermenu
        h_powermenu = zeros(4,1);
        h_powermenu(1) = uimenu(h_power,'Label',...
                 'Mean Squared Error Plots: Fig 3',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','off','CallBack','make_plot(2.0);');
        h_powermenu(2) = uimenu(h_power,'Label',...
                 'Total Power Remaining: Fig 4',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','off','CallBack','make_plot(2.1);');
        h_powermenu(3) = uimenu(h_power,'Label',...
                 'Row-Wise Power Remaining: Fig 4',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','off','CallBack','make_plot(2.2);');
        h_powermenu(4) = uimenu(h_power,'Label',...
                 'Both Power Remaining: Fig 4',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','off','CallBack','make_plot(2.3);');

% Risk plots submenus
%
        global h_riskmenu
        h_singlemenu = uimenu(h_risk,'Label',...
                 'Single Coefficient Risk Plots: Fig. 5 ',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','on','CallBack','make_plot(3.0);');
        h_thrscalemenu = uimenu(h_risk,'Label',...
                 'As a function of Initial Threshold Scale',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','off','Separator','on');       
        h_thrsizemenu = uimenu(h_risk,'Label',...
                 'As a function of Sample Size',...      
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','off','Separator','on');
        h_thrnoismenu = uimenu(h_risk,'Label',...
                 'As a function of Noise Level',...      
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','off','Separator','on');
        h_thrvalmenu = uimenu(h_risk,'Label',...
                 'As a function of Threshold Value',...      
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 0],...
                 'Checked','off','Separator','on');

% 
% To make Threshold Scale plots - Figs E,F,G
%    Make submenus of h_riskmenu(2)

       global h_scalemenu
       h_scalemenu = zeros(3,1);
       h_scalemenu(1) = uimenu(h_thrscalemenu,'Label',...
                 'Comparison of bases: Fig. 6 ',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 1],...
                 'Checked','on','CallBack','make_plot(3.11);');
       h_scalemenu(2) = uimenu(h_thrscalemenu,'Label',...
                 'Comparison of Threshold types: Fig. 7',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 1],...
                 'Checked','off','CallBack','make_plot(3.12);');
       h_scalemenu(3) = uimenu(h_thrscalemenu,'Label',...
                 'Comparison of Threshold schemes: Fig. 8',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 1],...
                 'Checked','off','CallBack','make_plot(3.13);');

%
% To make plot H,I
%
       global h_sizemenu 
       h_sizemenu = zeros(2,1);
       h_sizemenu(1) = uimenu(h_thrsizemenu,'Label',...
                 'Comparison of bases: Fig. 9',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 1],...
                 'Checked','on','CallBack','make_plot(3.21);'); 
       h_sizemenu(2) = uimenu(h_thrsizemenu,'Label',...
                 'Comparison of Threshold schemes: Fig. 10',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 1],...
                 'Checked','off','CallBack','make_plot(3.22);');

       global h_noisemenu 
       h_noisemenu = zeros(1,1);
       h_noisemenu(1) = uimenu(h_thrnoismenu,'Label',...
                 'Comparison of Threshold schemes: Fig. 11',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 1],...
                 'Checked','on','CallBack','make_plot(3.31);');

        global h_valuemenu
        h_valuemenu = zeros(2,1);
        h_valuemenu(1) = uimenu(h_thrvalmenu,'Label',...
                  'Comparison of Threshold values (Hard): Fig. 12',...
                  'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 1],...
                 'Checked','on','CallBack','make_plot(3.41);');
        h_valuemenu(2) = uimenu(h_thrvalmenu,'Label',...
                 'Comparison of Threshold values (Soft): Fig 13',...
                 'BackgroundColor',back_color,...
                 'ForegroundColor',[0 1 1],...
                 'Checked','off','CallBack','make_plot(3.42);');

%   INITIALIZE FIGURE
%
        global HC PlotFig
        PlotFig = 1;
        %   set up default values
%
        n = 256;
        x_length = n;
        x_name = ' ';
        if Wav_type == [],
          Wav_type = 'Haar';
        end
        if threshtype == [],
          threshtype = 'Hard';
        end
        if noiseamp == [],
         noiseamp = 0.02;       % Low Noise
        end
        if noisetype == [],
          noisetype = 'Normal';
        end;
        Empty_Data = 1;
        signal_name = '';
        panel = n/2;
        ylim  = [-1 1];
        x_use  = zeros(1,n);
        sigchoice = zeros(1,10);
%
%
%       set up signal window
%
figure(PlotFig);
axes('position',[0.05,0.25,0.9,.65]);
set( PlotFig, 'Name', 'Signal: Nil' );
set(PlotFig,'UserData',[ylim,panel,x_use]);
set(PlotFig,'units','normal','position',[0.05,0.6,0.4,0.4]);
HC = ...
uicontrol('style','slider','units','normal','pos',[.05,.05,.9,.05],...
      'min',0,'max',1,'value',.5,...
     'call','do_button(''slider'');');
uicontrol('style','pushbutton','units','normal','string','*2  ',...
     'pos',[0.05,0.11,0.1, 0.05],...
     'call','do_button(''double'');');
uicontrol('style','pushbutton','units','normal','string','/2  ',...
     'pos',[0.15,0.11,0.1, 0.05],...
     'call','do_button(''half'');');
uicontrol('style','pushbutton','units','normal','string','Prev',...
     'pos',[0.25,0.11,0.1, 0.05],...
     'call','do_button(''prev'');');
uicontrol('style','pushbutton','units','normal','string','Next',...
     'pos',[0.35,0.11,0.1, 0.05],...
     'call','do_button(''next'');');
uicontrol('style','pushbutton','units','normal','string','Full',...
     'pos',[0.45,0.11,0.1, 0.05],...
     'call','do_button(''full'');');
uicontrol('style','pushbutton','units','normal','string','Play',...
     'pos',[0.65,0.11,0.1, 0.05],...
     'call','do_button(''play'');');
uicontrol('style','pushbutton','units','normal','string','Zoom',...
     'pos',[0.75,0.11,0.1, 0.05],...
     'call','do_button(''zoom'');');

redo_plot(get(HC,'value'));
text(.4*n,.5,['Select Data or Signal to start']);
 

        fig_hand1 = figure;
        set( fig_hand1, 'Name', 'Basis Transforms', ...
             'units','normal','position',[0.3,0.6,0.4,0.4]);

        fig_hand2 = figure;
        set( fig_hand2, 'Name', 'Power Remaining', ...
              'units','normal','position',[0.6,0.6,0.4,0.4]);

        fig_hand3 = figure;
        set( fig_hand3, 'Name', 'Exact Risk Plots', ...
               'units','normal','position',[0.05,0.1,0.4,0.4]);
        
        fig_hand4 = figure;
        set( fig_hand4, 'Name', 'Auxilliary Window', ...
               'units','normal','position',[0.3,0.1,0.4,0.4]);
        figure(PlotFig);

global fig_list
fig_list = [0 0 0 0];
        
clear num_menu_items num_menus menu_id menu_label menu_names menu_name
clear menu_tag h_len h_nty h_nlv h_wav h_thr
clear panel st ylim
    
    
%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
