% CorrelIntro -- Info about CorrelDemo
% 
% The files in this directory can reproduce the figures in the paper
%    ``Wavelet Threshold Estimators for Data with Correlated Noise"
% by I.M. Johnstone and B.W. Silverman.
% 
%
% From the abstract: Wavelet threshold estimators for data with
% stationary correlated noise are constructed by applying a
% level-dependent soft threshold to the coefficients in the wavelet
% transform.  A variety of threshold choices are proposed, including one
% based on an unbiased estimate of mean squared error.  The practical
% performance of the method is demonstrated on examples, including data
% from a neurophysiological context.  The theoretical properties of the
% estimators are investigated by comparing them with an ideal but
% unattainable `benchmark', that can be considered in the wavelet
% context as the risk obtained by ideal spatial adaptivity, and more
% generally is obtained by the use of an `oracle' that provides
% information not actually available in the data.  It is shown that the
% level-dependent threshold estimator performs well relative to the
% benchmark risk, and that its minimax behaviour cannot be improved upon
% in order of magnitude by any other estimator.  The wavelet domain
% structure of both short and long range dependent noise is considered,
% and in both cases it is shown that the estimators have near-optimal
% behaviour simultaneously in a wide range of function classes, adapting
% automatically to the regularity properties of the underlying model.
% The proofs of the main results are obtained by considering a more
% general multivariate normal decision-theoretic problem.
% 
    
    
%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
