% DATASTRUCTURES -- basic data structures in WaveLab
%
%   The following terms are used in the help files of the WaveLab system.
%   They are used in a specific way; for example a <<1-d signal>> is to be
%   a 1-by-n matrix, with n a power of 2.
%
%   1-d Signal          Preferably, a 1-by-n matrix, n dyadic (i.e. n=2^J). 
%                       Occur as input to FWT and also Dyad operators
%                       However, n-by-1 matrices are also valid input for
%                       FWT routines.  Automatically generated by MakeSignal
%                       and ReadSignal.
%   
%   QMF                 Quadrature Mirror Filter; a filter whose transfer
%                       function obeys special properties.
%                       Needed for Wavelet and Wavelet Packet Analysis. 
%                       Orthogonal qmf's are generated by MakeONFilter.
%                     
%   1-d Wavelet Transform
%                       A sequence of length n, n dyadic (i.e. a power of 2).
%                       Takes the same shape as the <<1-d signal>> it is the
%                       transform of; if that signal is n by 1, then so is
%                       the transform. Created by wavelet transform routines,
%                       e.g. FWT_PO. 
%                     
%   1-d Wavelet Indexing
%                       Wavelet coefficients are indexed by scale and location.
%                       The scales run from some low-resolution cutoff L to 
%                       J-1, where n=2^J.  The locations at level j run from 0 
%                       to 2^j - 1. To access a specific wavelet coefficient,
%                       say the coefficient corresponding to scale j=6 and
%                       location k=21, use the function dyad2ix(j,k).
%                     
%                       Suppose that we create a 1-d wavelet transform via
%                           wt = FWT_PO(x,L,qmf);
%                       where x is a 1-d signal of length n=2^J. The last n/2
%                       entries of wt are the finest scale wavelet coefficients.
%                       The last n/4 before that are the next-to-finest scale
%                       coefficients.
%
%                       The coefficients at a given scale can be obtained via
%                       the function dyad; wt(dyad(j)) yields the collection of
%                       wavelet coefficients at scale j.  Here L <= j < J.
%                 
%   1-d Packet Table    An n by D+1 array, where n, a signal length, is dyadic
%                       and D is the maximum branching depth in a dyadic
%                       splitting of the frequency domain (wavelet packet table)
%                       or time domain (cosine packet table).  We must have
%                       0 <= D <= J, typically D < J.
%                       
%                       To display a packet table, use PlotPacketTable.
%                       
%                       Packet Tables are generated by WPAnalysis, CPAnalysis.
%                       They are used to compute a best basis for signal
%                       representation.  They are the primary input to 
%                       CalcStatTree and so, indirectly, to BestBasis.
%                       
%   1-d Packet Table Indexing
%                       The first column consists of the ``unsplit data,'' and
%                       the d+1-st column contains 2^d ``blocks,'' each with
%                       n/(2^d) ``coefficients,'' containing the results of
%                       splitting the domain into 2^d blocks and analyzing the
%                       blocks separately.  In the case of a wavelet packets
%                       table, the ``unsplit data'' amounts to the original
%                       signal.  In the case of a cosine packets table, the
%                       ``unsplit data'' amounts to the DCT-IV transform of
%                       the original signal.
%                       
%                       To access all the coefficients stored in the b-th block
%                       of the d-th level, use the function packet(d,b,n):
%                           pkt(packet(d,b,n),d+1).
%
%                       The data at various nodes of a tree or accessed by the
%                       node function:
%                           tree(node(d,b))
%                       will return the value of tree associated to the node at
%                       depth d and position b.
%
%   1-d Stat Tree       An intermediate data structure summarizing the contents
%                       of a packet table; it contains the entropy numbers
%                       summarizing statistically the contents of various nodes.
%                       It is intended for use in the BestBasis algorithm, and
%                       is generated by CalcStatTree.
%
%                       It is a 1 by N array, where N=2^D and D is the maximum
%                       depth of the tree.  i can be written as 2^d + b, where d,
%                       an integer, is the depth in the tree and 0 <= b < 2^d.
%                       Then Position i contains the entropy statistic for the
%                       block of a wavelet/cosine packet table indexed by
%                       packet(d,b,n).
%
%                       In conjunction with a 1-d basis tree one can display some
%                       of the information in a 1-d stat tree; see PlotBasisTree.
%
%   1-d Basis Tree      A data structure encoding a particular binary tree.  It
%                       is the output of the BestBasis algorithm.
%
%                       It is a 1 by N array, where N=2^D, and D is the maximum
%                       depth of a tree.  The shape of the tree is encoded by
%                       following the splits in the tree starting at the root.
%                       The values in the array are 1 or 0. The value at
%                       position i encodes whether that node is terminal or
%                       nonterminal: the value 1 indicates that the node is a
%                       branching node; the value 0 indicates that the node is
%                       a leaf node.  If the node is a branching node,
%                       information about its children is stored at 2 and 3.
%                       In general if the ancestors of position i contain the
%                       value 1, then node i is part of the tree.  If the value
%                       in position i is 1, then node i is a branching node and
%                       its children are at 2*i and 2*i+1.  If the value in
%                       position i is 0, then node i is a leaf node.
%
%                       There are special displays for 1-d basis trees; see
%                       PlotBasisTree.
%
%                       1-d basis trees are created by BestBasis starting from
%                       the input of a 1-d stat tree.  1-d basis trees are used
%                       to specify a certain orthogonal basis in invocations of 
%                       FTP and IPT which do fast forward and inverse packet
%                       transforms and by UnpackBasisCoeff and PackBasisCoeff,
%                       which get the coefficients of a signal in the indicated
%                       basis from a pre-existing packet table.
%                       
%   1-d Atom List       An N by 4 array, where N is the number of atoms in the
%                       list.  Each row contains information about one time-
%                       frequency atom.  It is in the form [a,d,b,k], where a
%                       is the (signed) amplitude attached to the atom and
%                       [d,b,k] is the packet table index of the corresponding
%                       wavlet or cosine packet atom.
%                       
%                       Generated by WPPursuit, CPPursuit.
%
%                       The corresponding time-frequency portrait can be
%                       visualized with PlotAtomicPhasePlane and with
%                       ImageAtomicPhasePlane.  The corresponding signal can
%                       be obtained by WPAtomicSynthesis and CPAtomicSynthesis.
%
%   2-d Signal          an n by n matrix, where n is dyadic.
%                       Valid input for 2-d Wavelet Transform (FWT2_PO).
%   
%   2-d Image           An n by n matrix, where n is dyadic. Usually takes
%                       gray-scale values 0 to 255 and should be displayed
%                       with colormap(gray(256)).
%                       Valid input for 2-d Wavelet Transform (FWT2_PO).
%
%   2-d Wavelet Transform
%                       An n-by-n matrix, n dyadic.  Results from 2-d Wavelet
%                       Transform (FWT2_PO).  Valid input for 2-d Inverse
%                       Wavelet Transform (IWT2_PO).
%
%   2-d Wavelet Indexing 
%                       2-d Wavelet coefficients are indexed by scale, location
%                       and orientation. The scales run from some low-resolution
%                       cutoff L to some J-1, where n=2^J.  The locations at
%                       level j run from 0 to 2^j - 1. The orientations at level
%                       j run through {1,2,3}, corresponding to E-W, N-S and
%                       diagonal sensitivities.
%
%                       To access a specific wavelet coefficient, say the
%                       coefficient corresponding to scale j=6, location k=21,
%                       use the function Quad2ix(j,k).
%                     
%                       Suppose that we create a 2-d wavelet transform via
%                           wt2 = FWT2_PO(x,L,qmf);
%                       where x is a 2-d signal of side n=2^J. The finest scale
%                       wavelet coefficients are in the L-shaped region
%                       of the array wt2 corrresponding to indices [kx,ky] with
%                       either kx or ky greater than the last n/2 entries. The
%                       next finest scale coefficients are in the L shaped
%                       region of the part of the matrix with [kx,ky] indices
%                       both n/2 or smaller, but of which at least one of the
%                       two indices exceeds n/4.
%                     
%                       Each L-shaped region consists of three square subregions
%                       corresponding to the three types of direction sensitivity
%                       of wavelets. For example, at the finest scale, the
%                       region with 1 <= kx <= n/2, but n/2 < ky <= n is the set 
%                       of coefficients with sensitivity E-W.
%                     
%                       The coefficients at a given scale and orientation can be
%                       obtained via the function quad; wt(quad(j,ep)) yields
%                       the collection of wavelet coefficients at scale j.
%                       Here L <= j < J.
%
%   2-d Packet Table    There are no 2-d packet tables in WaveLab -- they would
%                       be much too large.  Instead one calculates stat trees
%                       directly.
%
%   2-d Stat Tree       A primary data structure summarizing the contents of a
%                       packet table; it contains the entropy numbers which
%                       summarize statistically the contents of various nodes.
%                       It is intended for use in the Best2dBasis algorithm
%                       and is generated by Calc2dStatTree.
%
%                       A 1 by N array, where N=4^D, and D is the maximum depth
%                       of the tree.  i can be written as 4^d + b, where d, an
%                       integer, is the depth of the tree and 0 <= b < 4^d.
%                       Then position i contains an entropy statistic for the
%                       corresponding block of a wavelet/cosine packet table.
%
%                       In conjunction with a 2-d basis tree one can display
%                       some of the information in a 2-d stat tree; see
%                       Plot2dBasisTree.
%
%   2-d Basis Tree      A data structure encoding a particular quad tree.  It
%                       is the output of the Best2dBasis algorithm.
%
%                       A 2-d basis tree is a 1 by N array, where N=4^D, and
%                       D is the maximum depth of the tree.  The shape of the
%                       tree is encoded by following the splits in the tree
%                       starting at the root.  The values in the array are 1
%                       or 0.  The value at position i encodes whether that
%                       node is terminal or nonterminal: the value 1 indicates
%                       that the node is a branching node; the value 0 
%                       indicates that the node is a leaf node.  Position 1
%                       records information about the root.  If the node is a
%                       branching node, information about its children is
%                       stored at 2 and 3.  In general, if all the ancestors
%                       of position i contain the value 1, the node i is part
%                       of the tree.  If the value in position i is 1, then
%                       node is a branching node and its children are at 2*i
%                       and 2*i+1.  If the value in position i is 0, then node
%                       i is a leaf node.
%
%                       There are special displays for 2-d basis trees; see
%                       Plot2dBasisTree.
%
%                       2-d basis trees are created by Best2dBasis starting
%                       from the input of a 2-d stat tree.  2-d basis trees
%                       are used to specify a certain orthogonal basis in
%                       invocations of FPT2 and IPT2, which do fast forward
%                       and inverse packet transforms.
%

%        
    
    
%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
