%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%This code is to solve the Modified-CS-residual problem
%%%%min ||y_res-Ax||_2^2+gamma ||x_{T^c}||_1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addpath('WaveLab8.02/Orthogonal/'); % needed for wavestrapping resampling
clear;
randn('state',0)
rand('state',0)


SCAN = '17086_2'; % file to add BOLD contrast to
CNR = 4; % average CNR of added BOLD signal
NSIM = 10; % number of repeated simulations to uniquely resampled noise




%%%% Generating n = m sampling mask when t = 1
N =[64 64];
[pdf,val] = genPDF(N,3,1,2,0,0);  
[mask1,stat,NN] = genSampling(pdf,100,10);
mask1=fftshift(mask1);            
 
%%%% Generating n = 0.31m sampling mask, this mask will later be modified
%%%% to be the sampling mask when t > 1
[pdf,val] = genPDF(N(1),4,0.4,2,0,0);
[mask2r,stat,NN] = genSampling(pdf,100,10);
mask2r=fftshift(mask2r);

mask2_temp = mask2r'*ones(1,N(1));


for sim=1:NSIM
    
      clear y;
 
    % load data
    load([SCAN '.mat']);            % loads data into variable "data"
    load([SCAN '_BOLDmask.mat']);   % loads data into variable "mask" (created from activation scan 16486)
    load('BOLDshape.mat');          % shape of BOLD signal in variable BOLD (created using BOLDmodel and BOLDmodelParams)
    
    % make sure BOLD data has max of 1
    BOLD = BOLD/max(BOLD(:));
    
    sz = size(data);
    data = reshape(data, prod(sz(1:3)), sz(4)).';    % turn into columns for resampling
    data = synthesizefMRIDataset(data);              % resample to get "new" observation of noise based on seed dataset
    data = reshape(data.', sz);                      % back to 4-D
    
    % compute noise in rest data
    noise_std = std(abs(data), 0, 4);
    
    % compute average noise of voxels that will be made active
    idxActiveVoxels = find(mask==1);
    noise_std_ave = mean(noise_std(idxActiveVoxels));
    
    % compute necessary signal amplitude to give desired SNR
    req_contrast = CNR*noise_std_ave;
        
    
    % add contrast
    for k=1:size(data,4)
        data(:,:,:,k) = data(:,:,:,k) + mask*BOLD(k)*req_contrast;
    end
    
    % Define the 9th slice of the data to be ground truth 
    orgdata=squeeze(data(:,:,9,:));
    % Define the true active mask
    activemask = mask(:,:,9);
    
    
    data_3d=squeeze(orgdata(1:end,1:end,1:end));


 

    gamma=0.1;          %gamma for BPDN
    gammamodcsres=0.01;     %gamma for modified-cs-residual





    N0=size(data_3d);
    N=[N0(1) N0(2)];






    %%%% In the pre-defined mask2_temp, keep most of the low frequency
    %%%% region samples and randomly select one high frequency region sample.

    mask2= zeros(64,64);
    for i = 1:11
        mask2(i,:) =mask2_temp(i,:);
    end
    
    for i = 53:64
        mask2(i,:)=mask2_temp(i,:);
    end

    sampleIndex = randi([12,52],[1,1]);

    mask2(sampleIndex,:)=1;








    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%wavelet transform 
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    L=2;
    dwtmode('per'); 

    Xtmp=eye(N);

    W=zeros(N);
    for p=1:N(1)
        [W(:,p),L2] = wavedec(Xtmp(:,p),L,'db4');
    end

    %generate wavelet transform operator
    XFM = Wavelet(W);	


    %generate Fourier sampling operator
    FT1 = p2DFT(mask1, N, 1, 2);
    FT2 = p2DFT(mask2,N,1,2);


    
    
    seqlen=90;

    %Obtain measurements
    for seq=1:seqlen

       if seq==1
           
           FT=FT1;
           mask=mask1;
           
       else
           
           FT = FT2;
           mask = mask2;
        
       end
       
       
    
   y{seq}=FT*data_3d(:,:,seq);     %generate noisy measurements

  
    end
 



 
    for seq=1:seqlen
                                 
            dataseq(:,:,seq)=W*data_3d(1:end,1:end,seq)*W';
            dataseq1(:,seq)=reshape(W*data_3d(1:end,1:end,seq)*W',prod(N),1);
    end





    thr_recon = 600;    %threshold of modified-cs-residual


    %%%%%%%Do Modified-CS-residual with Causal Detection

    [xhat_modcsres,T_active,amap_seq]=modcsresCausalDetection(FT1,mask1,FT2,mask2,XFM,gammamodcsres,y,thr_recon,dataseq,dataseq1);

    %%%%%%Compute reconstruction error

    for seq=1:90

            error_modcsres(seq)=norm(abs(xhat_modcsres(:,:,seq))-abs(XFM'*dataseq(:,:,seq)),'fro')/norm(abs(XFM'*dataseq(:,:,seq)),'fro')
    
 
    end


    %%%%%%%Do Kt-FOCUSS

    %%%% Obtain k-space data from ground truth
    for seq = 1:90

        kSpace(:,:,seq) = fft2(data_3d(:,:,seq));

    end


    %%%% Generate the sequential sampling mask for Kt-FOCUSS.
    M = zeros(64,64,90);
    M(:,:,1)=1;

    for seq = 1:89
        M(:,:,seq+1) = mask2;
    end

    y_samp=kSpace.*M;
    
    
    xhat_ktFOCUSS=KTFOCUSS(y_samp);

    %%%%%%Compute reconstruction error
    
    for seq=1:90
  
            error_ktfocuss(seq)=norm(abs(xhat_ktFOCUSS(:,:,seq))-abs(XFM'*dataseq(:,:,seq)),'fro')/norm(abs(XFM'*dataseq(:,:,seq)),'fro')
    
  
    end

    
    
    %%%%%%%Do BPDN

    xhat_BPDN=BPDNsequential(FT1,mask1,FT2,mask2,XFM,gamma,y,dataseq);

    %%%%%%Compute reconstruction error
    
    for seq=1:seqlen

            error_BPDN(seq)=norm(abs(xhat_BPDN(:,:,seq))-abs(XFM'*dataseq(:,:,seq)),'fro')/norm(abs(XFM'*dataseq(:,:,seq)),'fro')
    
 
    end
   



    %%%%%%%Do CS-diff
    
    [xhat_csdiff]=csdiffsequential(FT1,mask1,FT2,mask2,XFM,gamma,y,dataseq);

    %%%%%%Compute reconstruction error

    for seq=1:seqlen

            error_csdiff(seq)=norm(abs(xhat_csdiff(:,:,seq))-abs(XFM'*dataseq(:,:,seq)),'fro')/norm(abs(XFM'*dataseq(:,:,seq)),'fro')
    

    end





    %%%%%%%Do CS-residual

    [xhat_csres]=csresidualsequential(FT1,mask1,FT2,mask2,XFM,gammamodcsres,y,thr_recon,dataseq,dataseq1);

    %%%%%%Compute reconstruction error

    for seq=1:90

            error_csres(seq)=norm(abs(xhat_csres(:,:,seq))-abs(XFM'*dataseq(:,:,seq)),'fro')/norm(abs(XFM'*dataseq(:,:,seq)),'fro')
    
 
    end


    save(['recondata_CNR = 4_slice9_' num2str(sim)],'data_3d','activemask','mask2','xhat_modcsres','error_modcsres','xhat_ktFOCUSS','error_ktfocuss','xhat_BPDN','error_BPDN','xhat_csdiff','error_csdiff','T_active','amap_seq','xhat_csres','error_csres')

end











