%%%%%%%%%%%%%%Compute the probability of detection and the probability of
%%%%%%%%%%%%%%false detection for each method



for i = 1:10

load (['recondata_CNR = 4_slice9_' num2str(i)])
load (['slice9_fullsample_CNR=4_' num2str(i)])

% build active and rest indexes
A = zeros(10,9);
A(:,[2:2:end])=1;
A(:,[3:2:end])=-1;
idxActive = find(A==1);
idxRest   = find(A==-1);



%%%%%%%%%%%%%%% Mod-CS-res
ihat1 = xhat_modcsres;

background_modcsres = mean(abs(ihat1),3);
sz_modcsres = size(background_modcsres);

xhat_modcsresnew = reshape(ihat1, prod(sz_modcsres), size(ihat1,3)).';
    
amap_modcsres = activationmap(abs(xhat_modcsresnew), 'ttest', sz_modcsres, background_modcsres, 'idxActive', idxActive, 'idxRest', idxRest, 'threshold.t', 2);

% compute ROC at specified Pf values
PF = linspace(0, .2, 201);
maskTrue = activemask; % mask of true activation (=1), background (-1) and inactive (0)
[frac_truemodcsres, frac_falsemodcsres,a,b,tau] = computefMRIROC(amap_modcsres, PF, maskTrue);

frac_truemodcsres = frac_truemodcsres';
frac_falsemodcsres = frac_falsemodcsres';

eval(['frac_falsemodcsres' num2str(i) '= frac_falsemodcsres']);
eval(['frac_truemodcsres' num2str(i)  '= frac_truemodcsres']);


%%%%%%%%%%%%%%ktFOCUSS
ihat2 = xhat_ktFOCUSS;

background_kt = mean(abs(ihat2),3);
sz_kt = size(background_kt);

xhat_ktnew = reshape(ihat2, prod(sz_kt), size(ihat2,3)).';

    
amap_kt = activationmap(abs(xhat_ktnew), 'ttest', sz_kt, background_kt, 'idxActive', idxActive, 'idxRest', idxRest, 'threshold.t', 3);

% compute ROC at specified Pf values
PF = linspace(0, .2, 201);
maskTrue = activemask; % mask of true activation (=1), background (-1) and inactive (0)
[frac_truekt, frac_falsekt,a2,b2,tau2] = computefMRIROC(amap_kt, PF, maskTrue);


frac_falsekt = frac_falsekt';
frac_truekt = frac_truekt';

eval(['frac_falsekt' num2str(i) '= frac_falsekt']);
eval(['frac_truekt' num2str(i) '= frac_truekt']);

%%%%%%%%%%%%%%%% Full sampling 

ihat3 = xhat_fullsample;


background_fullsample = mean(abs(ihat3),3);
sz_fullsample = size(background_fullsample);

xhat_fullsamplenew = reshape(ihat3, prod(sz_fullsample), size(ihat3,3)).';

    
amap_fullsample = activationmap(abs(xhat_fullsamplenew), 'ttest', sz_fullsample, background_fullsample, 'idxActive', idxActive, 'idxRest', idxRest, 'threshold.t', 3);

% compute ROC at specified Pf values
PF = linspace(0, .2, 201);
maskTrue = activemask; % mask of true activation (=1), background (-1) and inactive (0)
[frac_truefullsample, frac_falsefullsample,a3,b3,tau3] = computefMRIROC(amap_fullsample, PF, maskTrue);


frac_falsefullsample = frac_falsefullsample';
frac_truefullsample = frac_truefullsample';

eval(['frac_falsefullsample' num2str(i) '= frac_falsefullsample']);
eval(['frac_truefullsample' num2str(i) '= frac_truefullsample']);

 
% %%%%%%%%%%%%%%%CS diff 
% 
ihat4 = xhat_csdiff;


background_csdiff = mean(abs(ihat4),3);
sz_csdiff = size(background_csdiff);

xhat_csdiffnew = reshape(ihat4, prod(sz_csdiff), size(ihat4,3)).';

    
amap_csdiff = activationmap(abs(xhat_csdiffnew), 'ttest', sz_csdiff, background_csdiff, 'idxActive', idxActive, 'idxRest', idxRest, 'threshold.t', 3);

% compute ROC at specified Pf values
PF = linspace(0, .2, 201);
maskTrue = activemask; % mask of true activation (=1), background (-1) and inactive (0)
[frac_truecsdiff, frac_falsecsdiff,a4,b4,tau4] = computefMRIROC(amap_csdiff, PF, maskTrue);


frac_falsecsdiff = frac_falsecsdiff';
frac_truecsdiff = frac_truecsdiff';

eval(['frac_falsecsdiff' num2str(i) '= frac_falsecsdiff']);
eval(['frac_truecsdiff' num2str(i) '= frac_truecsdiff']);


%%%%%%%%%%%%%%%%%%%% BPDN

ihat5 = xhat_BPDN;


background_BPDN = mean(abs(ihat5),3);
sz_BPDN = size(background_BPDN);

xhat_BPDNnew = reshape(ihat5, prod(sz_BPDN), size(ihat5,3)).';

    
amap_BPDN = activationmap(abs(xhat_BPDNnew), 'ttest', sz_BPDN, background_BPDN, 'idxActive', idxActive, 'idxRest', idxRest, 'threshold.t', 3);

% compute ROC at specified Pf values
PF = linspace(0, .2, 201);
maskTrue = activemask; % mask of true activation (=1), background (-1) and inactive (0)
[frac_trueBPDN, frac_falseBPDN,a5,b5,tau5] = computefMRIROC(amap_BPDN, PF, maskTrue);



frac_falseBPDN = frac_falseBPDN';
frac_trueBPDN = frac_trueBPDN';

eval(['frac_falseBPDN' num2str(i) '= frac_falseBPDN']);
eval(['frac_trueBPDN' num2str(i) '= frac_trueBPDN']);




save(['PFTF_slice9_CNR=4' num2str(i)], ['frac_falsemodcsres' num2str(i)],['frac_truemodcsres' num2str(i)],['frac_falsekt' num2str(i)],['frac_truekt' num2str(i)],['frac_truecsdiff' num2str(i)],['frac_falsecsdiff' num2str(i)],['frac_trueBPDN' num2str(i)],['frac_falseBPDN' num2str(i)],['frac_falsefullsample' num2str(i)],['frac_truefullsample' num2str(i)])
% save(['PFTF_slice9_CNR=4' num2str(i)], ['frac_falsemodcsres' num2str(i)],['frac_truemodcsres' num2str(i)],['frac_falsekt' num2str(i)],['frac_truekt' num2str(i)],['frac_truecsdiff' num2str(i)],['frac_falsecsdiff' num2str(i)],['frac_trueBPDN' num2str(i)],['frac_falseBPDN' num2str(i)])
end





