%%%%%%%%%%%%%% Compute the mean of detection probability and false
%%%%%%%%%%%%%% detection probability 


clear all


for seq = 1:10
    load (['PFTF_slice9_CNR=4' num2str(seq)])
end

%%%% Define false detection matrix and true detection matrix for each
%%%% method

m_falsekt = zeros(10,201);

for seq = 1:10
    m_falsekt(seq,:) = eval(['frac_falsekt' num2str(seq)]);
end


m_truekt = zeros(10,201);

for seq = 1:10
    m_truekt(seq,:) = eval(['frac_truekt' num2str(seq)]);
end


m_falsemodcsres = zeros(10,201);
for seq = 1:10
    m_falsemodcsres(seq,:) = eval(['frac_falsemodcsres' num2str(seq)]);
end


m_truemodcsres = zeros(10,201);
for seq = 1:10
    m_truemodcsres(seq,:) = eval(['frac_truemodcsres' num2str(seq)]);
end


m_truefs = zeros(10,201);
for seq = 1:10
    m_truefs(seq,:) = eval(['frac_truefullsample' num2str(seq)]);
end

m_falsefs = zeros(10,201);
for seq = 1:10
    m_falsefs(seq,:) = eval(['frac_falsefullsample' num2str(seq)]);
end

m_truecsdiff = zeros(10,201);
for seq = 1:10
    m_truecsdiff(seq,:) = eval(['frac_truecsdiff' num2str(seq)]);
end

m_falsecsdiff = zeros(10,201);
for seq = 1:10
    m_falsecsdiff(seq,:) = eval(['frac_falsecsdiff' num2str(seq)]);
end

m_trueBPDN = zeros(10,201);
for seq = 1:10
    m_trueBPDN(seq,:) = eval(['frac_trueBPDN' num2str(seq)]);
end

m_falseBPDN = zeros(10,201);
for seq = 1:10
    m_falseBPDN(seq,:) = eval(['frac_falseBPDN' num2str(seq)]);
end





%%%% Compute the mean of both detection and false detection probability and
%%%% one standard deviation of the detection probability
tot=200;

for seq =1:201
    
mean_falsekt(seq) = mean(m_falsekt(:,seq));
mean_truekt(seq) = mean(m_truekt(:,seq));
std_truekt(seq)= std(m_truekt(:,seq));

for i = 1:tot
low_truekt{i}(seq) = mean_truekt(seq)-(i/tot)*std_truekt(seq);
high_truekt{i}(seq) = mean_truekt(seq)+(i/tot)*std_truekt(seq);

if high_truekt{i}(seq)>1
    high_truekt{i}(seq)=1;
end

end






mean_falsemodcsres(seq) = mean(m_falsemodcsres(:,seq));
mean_truemodcsres(seq) = mean(m_truemodcsres(:,seq));
std_truemodcsres(seq) = std(m_truemodcsres(:,seq));

for i = 1:tot
low_truemodcsres{i}(seq) = mean_truemodcsres(seq)-(i/tot)*std_truemodcsres(seq);
high_truemodcsres{i}(seq) = mean_truemodcsres(seq)+(i/tot)*std_truemodcsres(seq);

if high_truemodcsres{i}(seq)>1
    high_truemodcsres{i}(seq)=1;
end

end






mean_falsefs(seq) = mean(m_falsefs(:,seq));
mean_truefs(seq) = mean(m_truefs(:,seq));
std_truefs(seq)= std(m_truefs(:,seq));

for i = 1:tot
low_truefs{i}(seq) = mean_truefs(seq)-(i/tot)*std_truefs(seq);
high_truefs{i}(seq) = mean_truefs(seq)+(i/tot)*std_truefs(seq);

if high_truefs{i}(seq)>1
    high_truefs{i}(seq)=1;
end

end





mean_falsecsdiff(seq) = mean(m_falsecsdiff(:,seq));
mean_truecsdiff(seq) = mean(m_truecsdiff(:,seq));
std_truecsdiff(seq)= std(m_truecsdiff(:,seq));

for i = 1:tot
low_truecsdiff{i}(seq) = mean_truecsdiff(seq)-(i/tot)*std_truecsdiff(seq);
high_truecsdiff{i}(seq) = mean_truecsdiff(seq)+(i/tot)*std_truecsdiff(seq);

if high_truecsdiff{i}(seq)>1
    high_truecsdiff{i}(seq)=1;
end

end





mean_falseBPDN(seq) = mean(m_falseBPDN(:,seq));
mean_trueBPDN(seq) = mean(m_trueBPDN(:,seq));
std_trueBPDN(seq)= std(m_trueBPDN(:,seq));

for i = 1:tot
low_trueBPDN{i}(seq) = mean_trueBPDN(seq)-(i/tot)*std_trueBPDN(seq);
high_trueBPDN{i}(seq) = mean_trueBPDN(seq)+(i/tot)*std_trueBPDN(seq);

if high_trueBPDN{i}(seq)>1
    high_trueBPDN{i}(seq)=1;
end

end



end



hold on
%%%%Plot the one standard deviation region 

for i = 1:tot
plot(mean_falsekt,low_truekt{i},'Color',[0.90 0.90 0.90]);
plot(mean_falsekt,high_truekt{i},'Color',[0.90 0.90 0.90]);
end


for i = 1:tot
plot(mean_falsefs,low_truefs{i},'Color',[0.80 0.80 0.80]);
plot(mean_falsefs,high_truefs{i},'Color',[0.80 0.80 0.80]);
end

for i = 1:tot
plot(mean_falsemodcsres,low_truemodcsres{i},'Color',[0.7 0.7 0.7]);hold on;
plot(mean_falsemodcsres,high_truemodcsres{i},'Color',[0.7 0.7 0.7])
end

for i = 1:tot
plot(mean_falsecsdiff,low_truecsdiff{i},'Color',[0.90 0.90 0.90]);
plot(mean_falsecsdiff,high_truecsdiff{i},'Color',[0.90 0.90 0.90]);
end

for i = 1:tot
plot(mean_falseBPDN,low_trueBPDN{i},'Color',[0.80 0.80 0.80]);
plot(mean_falseBPDN,high_trueBPDN{i},'Color',[0.80 0.80 0.80]);
end



p1 = plot(mean_falsekt,mean_truekt,'b');
p2 = plot(mean_falsemodcsres,mean_truemodcsres,'r');
p3 = plot(mean_falsefs,mean_truefs,'k');
p4 = plot(mean_falsecsdiff,mean_truecsdiff,'y');
p5 = plot(mean_falseBPDN,mean_trueBPDN,'g');



title('ROC Curves for CNR = 4','Fonts',30);
xlabel('Probability of False Detection','Fonts',30);
ylabel('Probability of Detection','Fonts',30);

legend([p1,p2,p3,p4,p5],'ktFOCUSS 2 iterations','modCSres','FullSampling','CS-diff','BPDN');