function recon=KTFOCUSSmemc(y,recon_temp)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%% Hong's k-t FOCUSS code for cartesian trajectory %%%%%%%%%%%%%%%%%%%%%
% y: zero-padded measurements on k-t space, dimension=(ky, kx, time);
%    Assumed low frequency is positioned at vertex of k-space;
%    1<=ky<=4, end-3<=ky<=end : fully sampled region 
%    ky : phase encoding 
%    kx : frequency encoding
%    time : time frames
%
% M: sampling mask, same size with y, sampled point:1, otherwise: 0;
%    SAMPLING PATTERN should be RANDOM!!!
%    1<=ky<=4, end-3<=ky<=end : M(ky, kx, time)=1 
%
% pred: prediction term, temporal average or motion estimation/compensation can be used.
%       (default: pred=0 <- no prediction   )
%       (         pred=1 <- temporal average)
% factor: weighting matrix update power (0.5, 1), (default=0.5);
% lambda: regularization factor (default=0);
%         when noise is severe, increase lambda
% Minner: Iteration number of Conjugate Gradient (default=20);
% Mouter: FOCUSS iteration number (default=2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


   Mouter=1;

  Minner=20;
    
  lambda=0;
           
  factor=0.5;
             
   pred=1;
                
  M=zeros(size(y));
  M(find(abs(y)>0))=1;
  
  
  y_reference = y(:,:,1);
  
[nY, nX, nframe]=size(y);
y=ifft(y,[],2);
y=y.*M;

%%%%%%%%%%%% calculating ME/MC prediction %%%%%%%%%%%

 if pred ==1
   imgI = ifft2(y_reference);
   mbSize = 2;
   p = 1;
for i = 1:nframe
   imgP =  recon_temp(:,:,i);
    [motionVect, computations] = motionEstES(imgP,imgI,mbSize,p);
    imgComp = motionComp(imgI, motionVect, mbSize);
    image_est(:,:,i) = imgComp;
end


  image_est_Fourier = fft(image_est,[],1);

    for i=1:nframe
        y(:,:,i)=y(:,:,i)-image_est_Fourier(:,:,i);
    end
    y=y.*M;
 end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
%%%%%%%%%%%% Initializing weighting matrix %%%%%%%%%%%%%%%%
W=zeros(size(y));
W(1:4,:,:)=y(1:4,:,:);
W(end-3:end,:,:)=y(end-3:end,:,:);
W=ifft(W,[],1);
W=ifft(W,[],3);
W=abs(W).^factor;
if pred == 1
    W(:,:,1)=0;
end
W=W/max(W(:));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%% FOCUSS update %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
disp('ktFOCUSS ing...')
for outer=1:Mouter
    phi=zeros(size(W));
    x=zeros(size(W));
    for inner=1:Minner
        x=fft(x,[],3);
        x=fft(x,[],1);
        r=y-M.*x;
        r=r.*M;
        g=ifft(r,[],1);
        g=ifft(g,[],3);
        g=g*nY*nframe;
        g=-W.*g;
        g=g+lambda*phi;
        
        %% conjugate gradient
        if (inner>1)
            beta = g(:)'*g(:)/(prev_g(:)'*prev_g(:));
            d = -g+beta*prev_d;
        else
            d= -g;
        end

        prev_d = d;
        prev_g = g;
        %%%%%%%%%%%%%%%%%%%%%%
        
        z=W.*d;
        z=fft(z,[],3);
        z=fft(z,[],1);
        z=M.*z;
        alpha=(real(r(:)'*z(:)-lambda*(d(:)'*phi(:))))/(z(:)'*z(:)+lambda*d(:)'*d(:));
        phi=phi+alpha*d;
        x=W.*phi;
    end
    
 
    
    W=abs(x).^factor;    %%%%%%%% weighting matrix update
    W=W/max(W(:));  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    
    
    disp(['iteration #:', int2str(outer)])
end

recon=fft(x,[],3);

if pred == 1
    for i=1:nframe
        recon(:,:,i)=recon(:,:,i)+image_est(:,:,i);
    end
end
        
        