%To run the code: runsims_final,
%set run_kfcs = 1 to run kfcs, genie kf, edit save command as desired
%set run_cs = 1 to run regularcs, regularcs_no_noise, edit save command
%data saved in different files: see and modify save command as needed

%If you use this code, please cite:
%N. Vaswani, Kalman Filtered Compressed Sensing, ICIP 2008
% %N. Vaswani, Analyzing Least Squares and Kalman Filtered Compressed Sensing, ICASSP 2009
% 
% This file contains the following parts.
% 0. set paramaters
% Specify sigma0 (sigma_obs in the paper), sigsys (sigma_sys), siginit. 
% Alternatively directly specify R, Q, Pi0. 
% Set total_iters (number of realizations to average over)
% Set tot (total time, T)
% 
% 1. gendata_full
% a. simulates x(:,t) and y(:,t) = Ax(:,t) + w_t
% b. A = random Gaussian matrix (replace this by the desired matrix for your problem)
% c. x(:,t) follows a Gaussian random walk model, and support increases slowly (see code or ICASSP'09 for details)
% d. to run code on real data, comment out gendata_full and
% - save measurements into y(:,t), for all t. y is n x tot. 
% - x(:,t) is the coefficients in the sparsity basis
% - A = (measurement matrix)*(sparsity basis)
% e.g if running dynamic MRI reconstruction with wavelets as sparsity basis
% A = (H*F)*W' where H_{n x m} =random row sampling matrix, F_{m x m} = DFT matrix, W = 2D-DWT matrix. 
% (compute W by applying DWT2 to each column of identity matrix). 
% - Specify sigma0 (sigma_obs in the paper), sigsys (sigma_sys), siginit. 
%   Alternatively directly specify R, Q, Pi0. See 0. above.
% - set total_iters = 1
% 
% 2.  if run_kfcs==1,
% a. calls 6 functions to run the following 6 algorithms and the genie-KF 
% LS-CSresidual-LS (lscs), KF-CSresidual-LS (kfcsls) and KF-CSresidual-KF (kfcs), 
% each with and without deletion step and the genie KF. 
% 
% b. computes MSE's of each of them. saves data into a file. 
% 
% c. CSresidual uses Dantzig Selector to solve the noisy-CS problem: can replace this by BPDN for more efficient methods
% d. Also should replace linprog by code from CVX 
% 
% 3. if run_cs==1,
% a. runs CS-noiseless (regularcs_no_noise), CS Dantzig-Selector (regularcs) 
% b. computes MSE's. saves data into a file. 
% 
% 4. if sim==0
% Code for plotting, either set sim=0 or just copy-paste code to plot MSEs etc.



randn('state',0); rand('state',0); disp('random state 0 on')

%setting parameters
global n
global m
global tot
global lambdap
global S

tot = 80 %130 %100 %130
m = 256;    n = 72;
Sav =  16 ; %8 16 25; % round( n/log2(m/n) ) %S1 = S - 2;
cc = 1; %10 %multiply 'sigma' and 'a' by 'cc'
sigma0 =  cc* (1/3)*sqrt(Sav/n)
sigsys = 1;
siginit = 3;
lambdap = 4 %4 %beta = 2; lambdap = sqrt( (1+beta)*2*log2(m) ); prob_lb = 1 - 1/( sqrt(pi*log2(m))*m^beta )

%t2 = 5;

Agen = (1/sqrt(n)) * randn(n,m);
A = zeros(size(Agen));
for col = 1:m
    A(:,col) = Agen(:,col)/norm( Agen(:,col) );
end
R = (sigma0^2)*eye(n);
Q = (sigsys^2)*eye(m); %F = eye(m);
Pi0 = (siginit^2)*eye(m);

run_cs = 0;
run_kfcs = 1;
total_iters = 1 %100

for ct = 1: total_iters %[2,22,71]
    disp(ct)
    % code to generate data: generates x(:,t) and y(:,t) = Ax(:,t) + w_t
    % A is a random-Gaussian matrix. 
    gendata_full

    if run_kfcs
        % call lscs, kfcsls, kfcs and their versions without deletion step
        [x_upd_lscs,T_hat_lscs,x_upd_csres] = lscs_full(y,Pi0,A,Q,R);
        [x_upd_lscs_nodelete,T_hat_lscs_nodelete,x_upd_csres_nodelete] = lscs_full_nodelete(y,Pi0,A,Q,R);

        [x_upd_kfcsls_nodelete,T_hat_kfcsls_nodelete] = kfcsls_full_nodelete(y,Pi0,A,Q,R);
        [x_upd_kfcsls,T_hat_kfcsls] = kfcsls_full(y,Pi0,A,Q,R);
        
        [x_upd,T_hat] = kfcs_full(y,Pi0,A,Q,R);
        [x_upd_nodelete,T_hat_nodelete] = kfcs_full_nodelete(y,Pi0,A,Q,R);
        
        for t = 1:tot
             err_csres(ct,t) = norm( x(:,t)-x_upd_csres(:,t) )^2;
             err_lscs(ct,t) = norm( x(:,t)-x_upd_lscs(:,t) )^2;
            err_lscs_nodelete(ct,t) = norm( x(:,t)-x_upd_lscs_nodelete(:,t) )^2;        
            err_csres_nodelete(ct,t) = norm( x(:,t)-x_upd_csres_nodelete(:,t) )^2;
            
            err_kfcsls_nodelete(ct,t) = norm( x(:,t)-x_upd_kfcsls_nodelete(:,t) )^2;
            err_kfcsls(ct,t) = norm( x(:,t)-x_upd_kfcsls(:,t) )^2;
              
            err(ct,t) = norm( x(:,t)-x_upd(:,t) )^2;
            err_nodelete(ct,t) = norm( x(:,t)-x_upd_nodelete(:,t) )^2;
                        energy(ct,t) = norm( x(:,t) )^2;
        end
        %        disp(err(ct,:));
        % not_detected(ct) = length(setdiff(T,T_hat))
        %extra_detected(ct) = length(setdiff(T_hat,T))

        [x_upd_genie] = geniekf_full(y,Pi0,A,Q,R,Tt);
        for t = 1:tot
            err_genie(ct,t) = norm( x(:,t)-x_upd_genie(:,t) )^2;
        end
        save(['temp0_lscs_nodelete_',num2str(ct)])%kfcs3
        %save(['temp_lscs_nodelete_',num2str(ct)])%kfcs3
        disp(ct)
    end

    if run_cs
        [x_upd_regularcs_nonoise,T_hat] = regularcs_no_noise(y,Pi0,A,Q,R); %[x_upd] = regularcs(y,Pi0,A,Q,R);
        for t = 1:tot
            err_regularcs_nonoise(ct,t) = norm( x(:,t)-x_upd_regularcs_nonoise(:,t) )^2;
        end
        disp(err_regularcs_nonoise(ct,:))
        not_detected_regularcs_nonoise(ct) = length(setdiff(T,T_hat))

        [x_upd_regularcs,T_hat] = regularcs(y,Pi0,A,Q,R); %[x_upd] = regularcs(y,Pi0,A,Q,R);
        for t = 1:tot
            err_regularcs(ct,t) = norm( x(:,t)-x_upd_regularcs(:,t) )^2;
        end
        disp(err_regularcs(ct,:))
        not_detected_regularcs(ct) = length(setdiff(T,T_hat))
        save(['../temp0_cs_',num2str(ct)])%kfcs3
        disp(ct)
    end
end

% code for plotting MSE etc. 
sim=1;
if sim==0
    set(0,'defaultaxesfontsize',18)
%    load(['C:/Code/KFCS/temp_cs_',num2str(finct)])
    finct = 100;
    load(['C:/Code/KFCS/mat/data_cs_',num2str(finct)])
    load(['C:/Code/KFCS/temp_kfcs_',num2str(finct)])
    plot(mean(err_genie(1:finct,1:tot),1)./mean(energy(1:finct,1:tot),1),'k'), hold on
    plot(mean(err_regularcs_nonoise(1:finct,1:tot),1)./mean(energy(1:finct,1:tot),1),'r-^')
    plot(mean(err_regularcs(1:finct,1:tot),1)./mean(energy(1:finct,1:tot),1),'r-*')
    plot(mean(err(1:finct,1:tot),1)./mean(energy(1:finct,1:tot),1),'b-s')
    xlabel('time, t \rightarrow','FontSize',18)
    ylabel('normalized MSE \rightarrow','FontSize',18)

    for ct = 1:100
        %load(sprintf('temp_kfcs_%d',ct)), load(sprintf('temp_kfcsls_%d',ct))
        load(sprintf('temp0_kfcs_%d',ct)), load(sprintf('temp0_kfcsls_%d',ct)), load(sprintf('temp0_lscs_nodelete_%d',ct))
        for t=1:tot
            S_false_kfcsls(ct,t) = length( setdiff(find(abs(x_upd_kfcsls(:,t)) > 0),Tt{t}) );
            S_false_kfcsls_nodelete(ct,t) = length( setdiff(find(abs(x_upd_kfcsls_nodelete(:,t)) > 0),Tt{t}) );
            S_miss_kfcsls(ct,t) = length( setdiff(Tt{t},find(abs(x_upd_kfcsls(:,t)) > 0)) );
            S_miss_kfcsls_nodelete(ct,t) = length( setdiff(Tt{t},find(abs(x_upd_kfcsls_nodelete(:,t)) > 0)) );
            if t>1
                S_fa_kfcsls(ct,t) = length( setdiff(find(abs(x_upd_kfcsls(:,t-1)) > 0),Tt{t}) );
                S_fa_kfcsls_nodelete(ct,t) = length( setdiff(find(abs(x_upd_kfcsls_nodelete(:,t-1)) > 0),Tt{t}) );
            end

            S_false_lscs(ct,t) = length( setdiff(find(abs(x_upd_lscs(:,t)) > 0),Tt{t}) );
            S_false_lscs_nodelete(ct,t) = length( setdiff(find(abs(x_upd_lscs_nodelete(:,t)) > 0),Tt{t}) );
            S_miss_lscs(ct,t) = length( setdiff(Tt{t},find(abs(x_upd_lscs(:,t)) > 0)) );
            S_miss_lscs_nodelete(ct,t) = length( setdiff(Tt{t},find(abs(x_upd_lscs_nodelete(:,t)) > 0)) );
            if t>1
                S_fa_lscs(ct,t) = length( setdiff(find(abs(x_upd_lscs(:,t-1)) > 0),Tt{t}) );
                S_fa_lscs_nodelete(ct,t) = length( setdiff(find(abs(x_upd_lscs_nodelete(:,t-1)) > 0),Tt{t}) );
            end
        end
    end
    figure
    plot(mean(S_false_lscs_nodelete,1),'b-o'), hold on
    plot(mean(S_false_kfcsls_nodelete,1),'r-x')
    plot(mean(S_false_lscs,1),'b-^')
    plot(mean(S_false_kfcsls,1),'r->')
    title('false alarms N_t \ \hat{N}_t')
    legend('LS-CS-res-LS','KF-CS-res-LS','LS-CS-res-LS-del','LS-CS-res-LS-del')
    figure
    plot(mean(S_miss_lscs_nodelete,1),'b-o'), hold on
    plot(mean(S_miss_kfcsls_nodelete,1),'r-x')
    plot(mean(S_miss_lscs,1),'b-^')
    plot(mean(S_miss_kfcsls,1),'r->')
    title('misses, \hat{N}_t \ N_t')
    legend('LS-CS-res-LS','KF-CS-res-LS','LS-CS-res-LS-del','LS-CS-res-LS-del')
    figure
    plot(mean(S_fa_lscs_nodelete,1),'b-o'), hold on
    plot(mean(S_fa_kfcsls_nodelete,1),'r-x')
    plot(mean(S_fa_lscs,1),'b-^')
    plot(mean(S_fa_kfcsls,1),'r->')
    title('false adds, \hat{N}_{t-1} \ N_t')
    legend('LS-CS-res-LS','KF-CS-res-LS','LS-CS-res-LS-del','LS-CS-res-LS-del')
end
