
function [x_upd,T_hat] = geniekf(y,Pi0,A,Q,R,Tt)
global n
global m
global tot
global lambdap


sigma0 = sqrt(R(1,1));
sig2sys = Q(1,1);
sig2init = Pi0(1,1);

P_pred = zeros(m,m);
P_upd = zeros(m,m);

%Initial KF
t=1;
T_hat = Tt{1};
P_pred(T_hat,T_hat) = sig2init*eye(length(T_hat));
K = P_pred*A'*inv(R + A*P_pred*A');
P_upd  = ( eye(m) - K*A )*P_pred;
xpred = zeros(m,1);
xupd = xpred + K*(y(:,t) - A*xpred);
x_upd(:,t) = xupd;

for t = 2:tot
    % Defining Q
    T_hat_old = Tt{t-1};
    T_hat = Tt{t};
    Q1 = zeros(m,m); 
    diffset = setdiff(T_hat,T_hat_old);
    commonset = intersect(T_hat,T_hat_old);
    Q1(diffset,diffset) = sig2init*eye(length(diffset));
    Q1(commonset,commonset) = sig2sys*eye(length(commonset));

    % KF
    P_pred = P_upd + Q1;
    K = P_pred*A'*inv(R + A*P_pred*A');
    P_upd  = ( eye(m) - K*A )*P_pred;
    xpred = x_upd(:,t-1);
    xupd = xpred + K*(y(:,t) - A*xpred);
    x_upd(:,t) = xupd;
end

