clear;
clc;

randn('state',0)
rand('state',0)

addpath ../../solver/cvx/cvx-rd/cvx % This should be replace with the directory of cvx on you computer
cvx_setup;

m=200; % vector size m*1

mc=100; % number of monte carlo simulation

u = 0.1; % percentage of unknown support
e = 0.4; % percentage of extra support

for in=1:1:10
    n=10+in*10; % number of measurement, loop from 20 to 110
    s = 20; % support size
    for c = 1:1:mc

        %%% data generation
        
        x = zeros(m,1); 
        mu1 = zeros(m,1); 
        mu01 = zeros(m,1);
        mu001 = zeros(m,1);
        NE = randperm(m,floor((1+e)*s)); % union of support N and support prior knowledge T
        N = NE(1:s);
        x(N) = randn(s,1)*sqrt(5); % generated sparse vector
        mu1(N) = x(N) + randn(s,1)*sqrt(5); % signal value knowledge with sigma_e = sigma_x
        mu001(N) = x(N) + randn(s,1)*sqrt(5)*0.01; % signal value knowledge with sigma_e = 0.01*sigma_x
        A = randn(n,m); % measurement matrix
        A = normc(A); % normalize each column of A
        y = A*x; % measurement without noise
        
        T = union(NE(1:floor((1-u)*s)),NE(s+1:end)); % support knowledge
        
        %%% simple CS
        
        tic;
        cvx_begin
        variable b(m,1) 
        minimize norm(b,1)
        subject to
        A*b-y==0
        cvx_end
        
        xhat_cs_cvx = b;
        error_cs_cvx(in,c) = norm(xhat_cs_cvx - x)/norm(x);
        t_cs_cvx(in,c) = toc;
        
        
        %%% LS-CS
        
        tic
        Nhat = T;%find(abs(xhat_cs_yall1)>thresh);%
        xhat_init = zeros(m,1);
        xhat_init(Nhat) = inv(A(:,Nhat)'*A(:,Nhat))*A(:,Nhat)'*y;
        cvx_begin
        variable b(m,1) 
        minimize (norm(b,1))
        subject to
        A*b+A*xhat_init-y==0
        cvx_end

        xhat_ls_cs_cvx = b+xhat_init;
        error_ls_cs_cvx(in,c) = norm(xhat_ls_cs_cvx - x)/norm(x);
        t_ls_cs_cvx(in,c) = toc;
        
        
        %%% mod-CS
        
        Tc = setdiff([1:m],T);
        
        tic
        cvx_begin
        variable b(m,1) 
        minimize norm(b(Tc),1)
        subject to
        A*b==y
        cvx_end
        
        xhat_modcs_cvx = b;
        error_modcs_cvx(in,c) = norm(xhat_modcs_cvx - x)/norm(x);
        t_modcs_cvx(in,c) = toc;
        
        
        %%% weighted yall1
        tau = e;
        tic;
        cvx_begin
        variable b(m,1) 
        minimize norm(b(Tc),1) + tau*norm(b(T),1)
        subject to
        A*b==y
        cvx_end

        xhat_weighted_ell1_cvx = b;
        error_weighted_ell1_cvx(in,c) = norm(xhat_weighted_ell1_cvx - x)/norm(x);
        t_weighted_ell1_cvx(in,c) = toc;
        
        %%% CS-res
        tic;
        cvx_begin
        variable b(m,1) 
        minimize norm(b,1)
        subject to
        A*b+A*mu1-y==0
        cvx_end
        
        xhat_cs_res_cvx1 = b+mu1;
        error_cs_res_cvx1(in,c) = norm(xhat_cs_res_cvx1 - x)/norm(x);
        t_cs_res_cvx1(in,c) = toc;
        
        
        %%% CS-res
        tic;
        cvx_begin
        variable b(m,1) 
        minimize norm(b,1)
        subject to
        A*b+A*mu001-y==0
        cvx_end
        
        xhat_cs_res_cvx001 = b+mu001;
        error_cs_res_cvx001(in,c) = norm(xhat_cs_res_cvx001 - x)/norm(x);
        t_cs_res_cvx001(in,c) = toc;
        
    end
end



Temp = find(error_cs_cvx>1e-3); % find cases where the exact recovery fails
fail_cs_cvx=zeros(size(error_cs_cvx));
fail_cs_cvx(Temp)=1;

Temp = find(error_ls_cs_cvx>1e-3);
fail_ls_cs_cvx=zeros(size(error_ls_cs_cvx));
fail_ls_cs_cvx(Temp)=1;

Temp = find(error_modcs_cvx>1e-3);
fail_modcs_cvx=zeros(size(error_modcs_cvx));
fail_modcs_cvx(Temp)=1;

Temp = find(error_weighted_ell1_cvx>1e-3);
fail_weighted_ell1_cvx=zeros(size(error_weighted_ell1_cvx));
fail_weighted_ell1_cvx(Temp)=1;


Temp = find(error_cs_res_cvx1>1e-3);
fail_cs_res_cvx1=zeros(size(error_cs_res_cvx1));
fail_cs_res_cvx1(Temp)=1;


Temp = find(error_cs_res_cvx001>1e-3);
fail_cs_res_cvx001=zeros(size(error_cs_res_cvx001));
fail_cs_res_cvx001(Temp)=1;

mc = size(error_cs_cvx,2);
figure;
tx=1:1:10;
plot(tx*10+10,1-sum(fail_cs_cvx(tx,:),2)/mc,'bo-'); hold on;
plot(tx*10+10,1-sum(fail_ls_cs_cvx(tx,:),2)/mc,'b+-');
plot(tx*10+10,1-sum(fail_modcs_cvx(tx,:),2)/mc,'bd-');
plot(tx*10+10,1-sum(fail_weighted_ell1_cvx(tx,:),2)/mc,'bx-');
plot(tx*10+10,1-sum(fail_cs_res_cvx1(tx,:),2)/mc,'b>-');
plot(tx*10+10,1-sum(fail_cs_res_cvx001(tx,:),2)/mc,'b^-');
legend('CS','LS-CS','ModCS','Weighted ell1','CS-res-bad-prior','CS-res-good-prior')
xlabel('Measurement number n');
ylabel('Success percentages');
