clear;
clc;

randn('state',0)
rand('state',0)

addpath(genpath('code-from-other-groups'));
cvx_setup;

load data/larynx_seq
load data/larynx_seq_measurements.mat;

data_3d=I(60:91,60:91,:);
N=[32 32];
m=prod(N);

seqlen=20;
thresh=0.001;
mc=100;



for c=1:1:mc
    w=w_res{c};
    w2=w2_res{c};
    dataseq=zeros(prod(N),seqlen);
    y=zeros(n,1);
    for i=1:seqlen
        data_temp=W2d*reshape(data_3d(:,:,i),[prod(N) 1]);
        Nt{i}=energythreshold(data_temp,0.999);
        dataseq(:,i)=data_temp;
        y(:,i)=A{i}*dataseq(:,i)+w(:,i);     %generate noisy measurements
    end
    
    for i=1:1:2
        y1(:,i)=A1*dataseq(:,i)+w2(:,i);
    end
    
    Tinit=[];
    for i=1:1:8
        Tinit=union(Tinit,[1:8]+(i-1)*32);
    end

    %% parameters estimation
    sigma_obs = sqrt(10);
    rho = 2*sigma_obs; 
    
    %% CS
    tic;
    for i=1:1:seqlen
        if(i<=2)
            y2=y1(:,i);
            A2=A1;
            gamma = max(1e-2*max(max(abs(A1'*y1(:,1:2)))),sigma_obs*sqrt(log(m)));
        else
            y2=y(:,i);
            A2=A{i};
            gamma = max(1e-2*max(max(abs(A{i}'*y))),sigma_obs*sqrt(log(m)));
        end
        
        cvx_begin
        variable b(prod(N),1) 
        minimize gamma*norm(b,1)+0.5*square_pos(norm(y2-A2*b));
        cvx_end
        
        if sum(isnan(b))>0||isnan(cvx_optval)
            cvx_begin
            cvx_solver sdpt3
            variable b(prod(N),1) 
            minimize gamma*norm(b,1)+0.5*square_pos(norm(y2-A2*b));
            cvx_end
        end
        
        if sum(isnan(b))>0||isnan(cvx_optval)
            xhat(:,i)=0;
        else
            xhat(:,i)=b;
        end
        
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));
        Nhat{i} = find(abs(xhat(:,i))>rho);
    end
    xhat_cs_cvx(:,:,c)=xhat;
    error_cs_cvx(:,c)=error;
    Nhat_cs_cvx = Nhat;
    t_cs_cvx(c) = toc;
    
    Tinit=find(abs(xhat_cs_cvx(:,1))>rho);
    deltax = xhat_cs_cvx(:,2) - xhat_cs_cvx(:,1);
    deltax(setdiff(Nhat_cs_cvx{2},Nhat_cs_cvx{1}))=0;
    sigma_sys_hat = sqrt(sum(deltax.*deltax)/length(Nhat_cs_cvx{2}));
    tau = length(setdiff(Nhat_cs_cvx{1},Nhat_cs_cvx{2}))/length(Nhat_cs_cvx{2});
    
    
    %% CS-residual
    tic;
    for i=2:1:seqlen
        if(i==2)
            xhat(:,i-1)=xhat_cs_cvx(:,i-1,c);
            y2=y1(:,i)-A1*xhat(:,i-1);
            A2=A1;
        else
            y2=y(:,i)-A{i}*xhat(:,i-1);
            A2=A{i};
        end
        
        cvx_begin
        variable b(prod(N),1) 
        minimize gamma*norm(b,1)+0.5*square_pos(norm(y2-A2*b));
        cvx_end
        
        if sum(isnan(b))>0||isnan(cvx_optval)
            cvx_begin
            cvx_solver sdpt3
            variable b(prod(N),1) 
            minimize gamma*norm(b,1)+0.5*square_pos(norm(y2-A2*b));
            cvx_end
        end
        
        if sum(isnan(b))>0||isnan(cvx_optval)
            xhat(:,i)=xhat(:,i-1);
        else
            xhat(:,i)=xhat(:,i-1)+b;
        end
        
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));
        Nhat{i} = find(abs(xhat(:,i))>rho);
    end
    xhat_cs_res_cvx(:,:,c)=xhat;
    error_cs_res_cvx(:,c)=error;
    t_cs_res_cvx(c) = toc;
    
    
    %% reg-mod-bpdn
    lambdaset=[0.5 0.2 0.1 0.05 0.01 0.005 0.001 0.0001];
    for i=2:1:2
        if(i==1)
            mu_hat=xhat_cs_cvx(:,i,c);
            T=Nhat_cs_cvx{1};%Tinit;
            Delta=setdiff(Nhat_cs_cvx{i},T);
        else
            mu_hat=xhat_cs_cvx(:,i-1,c);
            T=Nhat_cs_cvx{i-1};
            Delta=setdiff(Nhat_cs_cvx{i},T);
        end
        [gammahat(i),lambdahat(i),g(i)]=gamma_star(A{i},T,Delta,y(:,i)-A{i}*xhat_cs_cvx(:,i,c),y(:,i),xhat_cs_cvx(:,i,c),mu_hat,lambdaset);
        Tc=setdiff(1:prod(N),T);
        
        opts.rho=gammahat(i);
        weight=ones(m,1);
        weight(T)=0;
        opts.weights=weight;
        opts.tol=1e-4;
        y2=lambdahat(i)*mu_hat(T);
        A2=zeros(length(T),m);
        for j=1:1:length(T)
            A2(j,T(j))=lambdahat(i);
        end

        cvx_begin
        variable x(prod(N),1)
        minimize gammahat(i)*norm(x(Tc),1)+0.5*lambdahat(i)*square_pos(norm(x(T)-mu_hat(T)))+0.5*square_pos(norm(y(:,i)-A{i}*x));
        cvx_end
        
        xhat(:,i)=x;
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));
        Nhat{i}=find(abs(xhat(:,i))>rho);
    end
    
    gamma=gammahat(2);
    lambda=lambdahat(2);
    
    tic
    for i=2:1:seqlen
        if(i==2)
            T=[Tinit];%find(abs(xhat_mod_bpdn(:,6))>rho);%
            y2=y1(:,i);
            A2=A1;
        else
            T=Nhat{i-1};
            y2=lambda*xhat(T,i-1);
            A2=zeros(length(T),m);
            for j=1:1:length(T)
                A2(j,T(j))=lambda;
            end
            y2=[y(:,i);y2];
            A2=[A{i};A2];
        end
        
        Tc=setdiff(1:prod(N),T);
        
        opts.rho=gamma;
        weight=ones(m,1);
        weight(T)=0;
        opts.weights=weight;
        opts.tol=1e-4;
        [x]=yall1(A2,y2,opts);
        
        xhat(:,i)=x;
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));
        Nhat{i}=find(abs(xhat(:,i))>rho);
        
    end
    
    xhat_reg_mod_bpdn(:,:,c)=xhat;
    error_reg_mod_bpdn(:,c)=error;
    t_reg_mod_bpdn_yall1(c) = toc;
         
    
    %% mod-bpdn
    lambdaset=0.0001;
    for i=2:1:2
        if(i==1)
            mu_hat=dataseq(:,i);
            T=Nt{1};%Tinit;
            Delta=setdiff(Nt{i},T);
        else
            mu_hat=xhat_cs_cvx(:,i-1,c);
            T=Nhat_cs_cvx{i-1};
            Delta=setdiff(Nhat_cs_cvx{i},T);
        end
        [gammahat(i),lambdahat(i),g(i)]=gamma_star(A{i},T,Delta,y(:,i)-A{i}*xhat_cs_cvx(:,i,c),y(:,i),xhat_cs_cvx(:,i,c),mu_hat,lambdaset);
        Tc=setdiff(1:prod(N),T);        
        cvx_begin
        variable x(prod(N),1) 
        minimize gammahat(i)*norm(x(Tc),1)+0.5*square_pos(norm(y(:,i)-A{i}*x));
        cvx_end
        
        if sum(isnan(x))>0||isnan(cvx_optval)
            xhat(:,i)=0;
            Nhat{i}=[];
        else
            xhat(:,i)=x;
            [Nhat{i},rho_hat(i)] = findthreshold(A{i},abs(xhat(:,i)),thresh,[]);
        end
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));
    end
    
    gamma=mean(gammahat(2:2));
    lambda=mean(lambdahat);    
    
    tic;
    for i=2:1:seqlen
        if(i==2)
            T=[Tinit];
            y2=y1(:,i);
            A2=A1;
        else
            T=Nhat{i-1};
            y2=y(:,i);
            A2=A{i};
        end
        Tc=setdiff(1:prod(N),T);
        
        cvx_begin
        variable x(prod(N),1) 
        minimize gamma*norm(x(Tc),1)+0.5*square_pos(norm(y2-A2*x));
        cvx_end
        
        if sum(isnan(x))>0||isnan(cvx_optval)
            xhat(:,i)=0;
            Nhat{i}=[];
            rho_hat(i)=0;
        else
            xhat(:,i)=x;
            [Nhat{i},rho_hat(i)] = findthreshold(A2,abs(xhat(:,i)),thresh,[]);
        end
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));        
    end
    xhat_mod_bpdn_cvx(:,:,c)=xhat;
    error_mod_bpdn_cvx(:,c)=error;
    t_mod_bpdn_cvx(c) = toc;        
        
    %% modcs-residual
    tic;    
    for i=2:1:seqlen
        if(i==2)
            T=[Tinit];
            xhat(:,i-1)=xhat_cs_cvx(:,i,c);
            y2=y1(:,i)-A1*xhat(:,i-1);
            A2=A1;
        else
            T=Nhat{i-1};
            y2=y(:,i)-A{i}*xhat(:,i-1);
            A2=A{i};
        end
        Tc=setdiff(1:prod(N),T);
                
        cvx_begin
        variable b(prod(N),1) 
        minimize gamma*norm(b(Tc),1)+0.5*square_pos(norm(y2-A2*b));
        cvx_end
        
        if sum(isnan(b))>0||isnan(cvx_optval)
            xhat(:,i)=xhat(:,i-1);
        else
            xhat(:,i)=xhat(:,i-1)+b;
        end
        
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));
        [Nhat{i},rho_hat(i)] = findthreshold(A2,abs(xhat(:,i)),thresh,[]);

    end
    xhat_modcs_res_cvx(:,:,c)=xhat;
    error_modcs_res_cvx(:,c)=error;
    rho_hat_modcs_res(:,c)=rho_hat;
    t_modcs_res_cvx(c) = toc;      
        
        
    %% kf-modcs
    tic;
    Ieye=eye(prod(N));
    for i=2:1:seqlen        
        if(i==2)
            xhat(:,i-1)=xhat_cs_cvx(:,i,c);
            y2=y1(:,i)-A1*xhat(:,i-1);
            A2=A1;
            T=Tinit;
            P_prev = sigma_sys_hat^2*Ieye(:,T)*Ieye(:,T)';
        else
            y2=y(:,i)-A{i}*xhat(:,i-1);
            A2=A{i};
            T=Nhat{i-1};
            P_prev=P_t;
        end
        Tc=setdiff(1:prod(N),T);
                
        cvx_begin
        variable b(prod(N),1) 
        minimize gamma*norm(b(Tc),1)+0.5*square_pos(norm(y2-A2*b));
        cvx_end
        
        if sum(isnan(b))>0||isnan(cvx_optval)
            xhat_modcs(:,i)=xhat(:,i-1);
        else
            xhat_modcs(:,i)=xhat(:,i-1)+b;
        end
                
        Nhat{i}=find(abs(xhat_modcs(:,i))>rho);

        if(i==6)
            xhat(:,i)=xhat_modcs(:,i);
            P_t=sigma_sys_hat^2*Ieye(:,Nhat{i})*Ieye(:,Nhat{i})';
        else
            Qhat=sigma_sys_hat^2*Ieye(:,Nhat{i})*Ieye(:,Nhat{i})';
            K=(P_prev+Qhat)*A{i}'*inv(A{i}*(P_prev+Qhat)*A{i}'+sigma_obs^2*eye(n));
            P_t=(Ieye-K*A{i})*(P_prev+Qhat);
            xhat(:,i)=(Ieye-K*A{i})*xhat(:,i-1)+K*y(:,i);
        end
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));
    end
    xhat_kf_modcs_cvx(:,:,c)=xhat;
    error_kf_modcs_cvx(:,c)=error;
    t_kf_modcs_cvx(c) = toc;      
    
    %% weighted ell1
    tic;
    for i=2:1:seqlen
        if(i==2)
            T=[Tinit];
            y2=y1(:,i);
            A2=A1;
        else
            T=Nhat{i-1};%Nt{i};%find(abs(dataseq(:,i))>rho);%
            y2=y(:,i);
            A2=A{i};
        end
        Tc=setdiff(1:prod(N),T);
        
        cvx_begin
        variable x(prod(N),1) 
        minimize gamma*norm(x(Tc),1)+gamma*tau*norm(x(T),1)+0.5*square_pos(norm(y2-A2*x));
        cvx_end
        
        xhat(:,i)=x;
        Nhat{i}=find(abs(xhat(:,i))>rho);
        error(i)=norm(xhat(:,i)-dataseq(:,i))/norm(dataseq(:,i));        
    end
    xhat_weighted_ell1_cvx(:,:,c)=xhat;
    error_weighted_ell1_cvx(:,c)=error;
    t_weighted_ell1_cvx(c) = toc;     
    
    
    %% DCS-AMP
    tic;
    for t=2:1:seqlen
        if t==2
            A_dcs{t-1} = A1;
        else
            A_dcs{t-1} = A{i};
        end
    end
    
    for t=2:1:seqlen
        if t==2
            y_dcs{t-1} = y1(:,t);
        else
            y_dcs{t-1}= y(:,t);
        end
    end
    
    Params.lambda_0 = (length(Nhat_cs_cvx{1})+length(Nhat_cs_cvx{2}))/2./ones(prod(N),1); %1/16 *ones(prod(N),1);
    Params.pz1 = length(setdiff(Nhat_cs_cvx{1},Nhat_cs_cvx{2}))./ones(prod(N),1); %0.01*ones(prod(N),1);
    Params.p1z = length(setdiff(Nhat_cs_cvx{2},Nhat_cs_cvx{1}))./ones(prod(N),1);  %Params.lambda_0.*Params.pz1./(1 - Params.lambda_0);    
    % Amplitude parameters
    Params.eta_0 = mean(xhat_cs_cvx(:,1:2),2); %zeros(prod(N),1);    
    N0 = intersect(Nhat_cs_cvx{1},Nhat_cs_cvx{2});
    Params.kappa_0 = mean(var(xhat_cs_cvx(N0,1:2)')); %1e3;            
    Params.alpha = corr(xhat_cs_cvx(:,1),xhat_cs_cvx(:,2)); %.05*ones(prod(N),1);
    Params.rho = var(xhat_cs_cvx(N0,2)' - xhat_cs_cvx(N0,1)'); %1e4;    
    Params.eps = 1e-7;
    Params.sig2e = sigma_obs^2;    
    Options.smooth_iter = -1;       % # of fwd/bwd passes (-1 to filter)
    Options.eq_iter = 10;           % # of inner AMP iterations
    Options.alg = 2;                % AMP
    Options.update = 1;             % Update hyperparameters during execution
    %Options.upd_groups = [{approx_coeff_group}, {detail_coeff_group}];
    Options.upd_groups{1} = 1:m;
    Options.verbose = 1;            % Print msgs
    
    [x_hat, v_hat, lambda_hat] = sp_multi_frame_fxn(y_dcs, A_dcs, Params, Options);
    
    for t = 2:1:seqlen
        xhat_dcsamp(:,t,c)=x_hat{t-1};
        error_dcsamp(t,c)=norm(x_hat{t-1}-dataseq(:,t))/norm(dataseq(:,t));
    end
    t_dcsamp(c) = toc;      
    
    %% PM-CS-KF
    tic;
    Pk0=eye(m)*1e2;
    beta_k=zeros(m,1);
    beta_kp=beta_k;
    p=0.5;
    n_iterations = 100;
    if p==0.5
        Re_p = 20000^2;
    elseif p ==0.7
        Re_p = 1000^2;
    elseif p==0
        Re_p = 100^2;
    end
    
    Q = eye(m)*1;
    R = eye(n)*sigma_obs^2;
    t_cskf1 = 0;
    Pk = Pk0;
    for i=2:1:seqlen        
        [beta_k, Pk]=CSKF_p(beta_k, Pk, y(:,i), A{i}, R, Re_p, n_iterations,p);  %%%  Algorithm CSKF-p is executing        
        Pk = Pk + Q;       
        xhat(:,i)=beta_k;        
        error(i) = norm(dataseq(:,i)-beta_k)/norm(dataseq(:,i));       
    end
    
    xhat_kf_cs(:,:,c)=xhat;
    error_kf_cs(:,c)=error;
    t_kf_cs(c) = toc;      
            
end


figure;
tx=2:1:20;
plot(tx,mean(error_reg_mod_bpdn(tx,:),2),'r.-'); hold on;
plot(tx,mean(error_mod_bpdn_cvx(tx,:),2),'bo-');
plot(tx,mean(error_cs_res_cvx(tx,:),2),'k:');
plot(tx,mean(error_cs_cvx(tx,:),2),'gs-');
plot(tx,mean(error_kf_modcs_cvx(tx,:),2),'m<-');
plot(tx,mean(error_dcsamp(tx,:),2),'bs-');
plot(tx,mean(error_weighted_ell1_cvx(tx,:),2),'ms-');
plot(tx,mean(error_kf_cs(tx,:),2),'r<-');
legend('regularized-modified-BPDN','moddified-BPDN','CS-res(BPDN-res)','BPDN','KMoCS','DCS-AMP','Weighted-l1','PM-CS-KF')
xlabel('time, t');
ylabel('NRMSE');



